<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251203003507 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE achats (id INT AUTO_INCREMENT NOT NULL, fournisseur_id INT NOT NULL, magasin_id INT NOT NULL, utilisateur_id INT NOT NULL, numero_facture VARCHAR(50) NOT NULL, montant_total NUMERIC(10, 2) NOT NULL, date_achat DATETIME NOT NULL, notes LONGTEXT DEFAULT NULL, UNIQUE INDEX UNIQ_9920924E38D27AB1 (numero_facture), INDEX IDX_9920924E670C757F (fournisseur_id), INDEX IDX_9920924E20096AE3 (magasin_id), INDEX IDX_9920924EFB88E14F (utilisateur_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE caracteristiques (id INT AUTO_INCREMENT NOT NULL, categorie_id INT NOT NULL, nom VARCHAR(255) NOT NULL, type VARCHAR(50) NOT NULL, valeurs_possibles LONGTEXT DEFAULT NULL, obligatoire TINYINT(1) NOT NULL, INDEX IDX_61B5DA1DBCF5E72D (categorie_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE categories (id INT AUTO_INCREMENT NOT NULL, magasin_id INT NOT NULL, nom VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, date_creation DATETIME NOT NULL, INDEX IDX_3AF3466820096AE3 (magasin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE depenses (id INT AUTO_INCREMENT NOT NULL, magasin_id INT NOT NULL, utilisateur_id INT NOT NULL, libelle VARCHAR(255) NOT NULL, categorie VARCHAR(50) NOT NULL, montant NUMERIC(10, 2) NOT NULL, date_depense DATETIME NOT NULL, justificatif VARCHAR(255) DEFAULT NULL, notes LONGTEXT DEFAULT NULL, INDEX IDX_EE350ECB20096AE3 (magasin_id), INDEX IDX_EE350ECBFB88E14F (utilisateur_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fournisseurs (id INT AUTO_INCREMENT NOT NULL, magasin_id INT NOT NULL, nom VARCHAR(255) NOT NULL, contact VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, telephone VARCHAR(20) DEFAULT NULL, adresse LONGTEXT DEFAULT NULL, date_creation DATETIME NOT NULL, actif TINYINT(1) NOT NULL, INDEX IDX_D3EF004120096AE3 (magasin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE lignes_achat (id INT AUTO_INCREMENT NOT NULL, achat_id INT NOT NULL, produit_id INT DEFAULT NULL, nom_produit VARCHAR(255) DEFAULT NULL, quantite INT NOT NULL, prix_unitaire NUMERIC(10, 2) NOT NULL, montant_total NUMERIC(10, 2) NOT NULL, INDEX IDX_8256A764FE95D117 (achat_id), INDEX IDX_8256A764F347EFB (produit_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE lignes_vente (id INT AUTO_INCREMENT NOT NULL, vente_id INT NOT NULL, produit_id INT NOT NULL, quantite INT NOT NULL, prix_unitaire NUMERIC(10, 2) NOT NULL, prix_achat_unitaire NUMERIC(10, 2) NOT NULL, montant_total NUMERIC(10, 2) NOT NULL, INDEX IDX_2C75097E7DC7170A (vente_id), INDEX IDX_2C75097EF347EFB (produit_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE logs_activite (id INT AUTO_INCREMENT NOT NULL, utilisateur_id INT NOT NULL, magasin_id INT NOT NULL, action VARCHAR(100) NOT NULL, entite VARCHAR(100) DEFAULT NULL, entite_id INT DEFAULT NULL, details LONGTEXT DEFAULT NULL, date_action DATETIME NOT NULL, ip_address VARCHAR(45) DEFAULT NULL, INDEX IDX_D5D66FA5FB88E14F (utilisateur_id), INDEX IDX_D5D66FA520096AE3 (magasin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE magasins (id INT AUTO_INCREMENT NOT NULL, nom VARCHAR(255) NOT NULL, adresse VARCHAR(255) DEFAULT NULL, ville VARCHAR(255) DEFAULT NULL, telephone VARCHAR(20) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, date_creation DATETIME NOT NULL, actif TINYINT(1) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE mouvements_stock (id INT AUTO_INCREMENT NOT NULL, produit_id INT NOT NULL, utilisateur_id INT NOT NULL, magasin_id INT NOT NULL, vente_id INT DEFAULT NULL, achat_id INT DEFAULT NULL, type VARCHAR(50) NOT NULL, quantite INT NOT NULL, quantite_avant INT NOT NULL, quantite_apres INT NOT NULL, date_mouvement DATETIME NOT NULL, justification LONGTEXT DEFAULT NULL, INDEX IDX_B3536722F347EFB (produit_id), INDEX IDX_B3536722FB88E14F (utilisateur_id), INDEX IDX_B353672220096AE3 (magasin_id), INDEX IDX_B35367227DC7170A (vente_id), INDEX IDX_B3536722FE95D117 (achat_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE produits (id INT AUTO_INCREMENT NOT NULL, categorie_id INT NOT NULL, magasin_id INT NOT NULL, fournisseur_id INT DEFAULT NULL, nom VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, prix_achat NUMERIC(10, 2) NOT NULL, prix_vente NUMERIC(10, 2) NOT NULL, quantite INT NOT NULL, code_barres VARCHAR(100) NOT NULL, etat VARCHAR(50) NOT NULL, date_entree DATETIME NOT NULL, caracteristiques_valeurs JSON DEFAULT NULL, actif TINYINT(1) NOT NULL, UNIQUE INDEX UNIQ_BE2DDF8C68EF62E0 (code_barres), INDEX IDX_BE2DDF8CBCF5E72D (categorie_id), INDEX IDX_BE2DDF8C20096AE3 (magasin_id), INDEX IDX_BE2DDF8C670C757F (fournisseur_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE users (id INT AUTO_INCREMENT NOT NULL, magasin_id INT NOT NULL, email VARCHAR(180) NOT NULL, roles JSON NOT NULL, password VARCHAR(255) NOT NULL, nom VARCHAR(255) NOT NULL, prenom VARCHAR(255) NOT NULL, telephone VARCHAR(20) DEFAULT NULL, actif TINYINT(1) NOT NULL, date_creation DATETIME NOT NULL, derniere_connexion DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_1483A5E9E7927C74 (email), INDEX IDX_1483A5E920096AE3 (magasin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE ventes (id INT AUTO_INCREMENT NOT NULL, vendeur_id INT NOT NULL, magasin_id INT NOT NULL, numero_facture VARCHAR(50) NOT NULL, montant_total NUMERIC(10, 2) NOT NULL, reduction NUMERIC(10, 2) DEFAULT NULL, montant_final NUMERIC(10, 2) NOT NULL, mode_paiement VARCHAR(50) NOT NULL, date_vente DATETIME NOT NULL, retour TINYINT(1) NOT NULL, notes LONGTEXT DEFAULT NULL, UNIQUE INDEX UNIQ_64EC489A38D27AB1 (numero_facture), INDEX IDX_64EC489A858C065E (vendeur_id), INDEX IDX_64EC489A20096AE3 (magasin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE achats ADD CONSTRAINT FK_9920924E670C757F FOREIGN KEY (fournisseur_id) REFERENCES fournisseurs (id)');
        $this->addSql('ALTER TABLE achats ADD CONSTRAINT FK_9920924E20096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE achats ADD CONSTRAINT FK_9920924EFB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE caracteristiques ADD CONSTRAINT FK_61B5DA1DBCF5E72D FOREIGN KEY (categorie_id) REFERENCES categories (id)');
        $this->addSql('ALTER TABLE categories ADD CONSTRAINT FK_3AF3466820096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE depenses ADD CONSTRAINT FK_EE350ECB20096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE depenses ADD CONSTRAINT FK_EE350ECBFB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE fournisseurs ADD CONSTRAINT FK_D3EF004120096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE lignes_achat ADD CONSTRAINT FK_8256A764FE95D117 FOREIGN KEY (achat_id) REFERENCES achats (id)');
        $this->addSql('ALTER TABLE lignes_achat ADD CONSTRAINT FK_8256A764F347EFB FOREIGN KEY (produit_id) REFERENCES produits (id)');
        $this->addSql('ALTER TABLE lignes_vente ADD CONSTRAINT FK_2C75097E7DC7170A FOREIGN KEY (vente_id) REFERENCES ventes (id)');
        $this->addSql('ALTER TABLE lignes_vente ADD CONSTRAINT FK_2C75097EF347EFB FOREIGN KEY (produit_id) REFERENCES produits (id)');
        $this->addSql('ALTER TABLE logs_activite ADD CONSTRAINT FK_D5D66FA5FB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE logs_activite ADD CONSTRAINT FK_D5D66FA520096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE mouvements_stock ADD CONSTRAINT FK_B3536722F347EFB FOREIGN KEY (produit_id) REFERENCES produits (id)');
        $this->addSql('ALTER TABLE mouvements_stock ADD CONSTRAINT FK_B3536722FB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE mouvements_stock ADD CONSTRAINT FK_B353672220096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE mouvements_stock ADD CONSTRAINT FK_B35367227DC7170A FOREIGN KEY (vente_id) REFERENCES ventes (id)');
        $this->addSql('ALTER TABLE mouvements_stock ADD CONSTRAINT FK_B3536722FE95D117 FOREIGN KEY (achat_id) REFERENCES achats (id)');
        $this->addSql('ALTER TABLE produits ADD CONSTRAINT FK_BE2DDF8CBCF5E72D FOREIGN KEY (categorie_id) REFERENCES categories (id)');
        $this->addSql('ALTER TABLE produits ADD CONSTRAINT FK_BE2DDF8C20096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE produits ADD CONSTRAINT FK_BE2DDF8C670C757F FOREIGN KEY (fournisseur_id) REFERENCES fournisseurs (id)');
        $this->addSql('ALTER TABLE users ADD CONSTRAINT FK_1483A5E920096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE ventes ADD CONSTRAINT FK_64EC489A858C065E FOREIGN KEY (vendeur_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE ventes ADD CONSTRAINT FK_64EC489A20096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE achats DROP FOREIGN KEY FK_9920924E670C757F');
        $this->addSql('ALTER TABLE achats DROP FOREIGN KEY FK_9920924E20096AE3');
        $this->addSql('ALTER TABLE achats DROP FOREIGN KEY FK_9920924EFB88E14F');
        $this->addSql('ALTER TABLE caracteristiques DROP FOREIGN KEY FK_61B5DA1DBCF5E72D');
        $this->addSql('ALTER TABLE categories DROP FOREIGN KEY FK_3AF3466820096AE3');
        $this->addSql('ALTER TABLE depenses DROP FOREIGN KEY FK_EE350ECB20096AE3');
        $this->addSql('ALTER TABLE depenses DROP FOREIGN KEY FK_EE350ECBFB88E14F');
        $this->addSql('ALTER TABLE fournisseurs DROP FOREIGN KEY FK_D3EF004120096AE3');
        $this->addSql('ALTER TABLE lignes_achat DROP FOREIGN KEY FK_8256A764FE95D117');
        $this->addSql('ALTER TABLE lignes_achat DROP FOREIGN KEY FK_8256A764F347EFB');
        $this->addSql('ALTER TABLE lignes_vente DROP FOREIGN KEY FK_2C75097E7DC7170A');
        $this->addSql('ALTER TABLE lignes_vente DROP FOREIGN KEY FK_2C75097EF347EFB');
        $this->addSql('ALTER TABLE logs_activite DROP FOREIGN KEY FK_D5D66FA5FB88E14F');
        $this->addSql('ALTER TABLE logs_activite DROP FOREIGN KEY FK_D5D66FA520096AE3');
        $this->addSql('ALTER TABLE mouvements_stock DROP FOREIGN KEY FK_B3536722F347EFB');
        $this->addSql('ALTER TABLE mouvements_stock DROP FOREIGN KEY FK_B3536722FB88E14F');
        $this->addSql('ALTER TABLE mouvements_stock DROP FOREIGN KEY FK_B353672220096AE3');
        $this->addSql('ALTER TABLE mouvements_stock DROP FOREIGN KEY FK_B35367227DC7170A');
        $this->addSql('ALTER TABLE mouvements_stock DROP FOREIGN KEY FK_B3536722FE95D117');
        $this->addSql('ALTER TABLE produits DROP FOREIGN KEY FK_BE2DDF8CBCF5E72D');
        $this->addSql('ALTER TABLE produits DROP FOREIGN KEY FK_BE2DDF8C20096AE3');
        $this->addSql('ALTER TABLE produits DROP FOREIGN KEY FK_BE2DDF8C670C757F');
        $this->addSql('ALTER TABLE users DROP FOREIGN KEY FK_1483A5E920096AE3');
        $this->addSql('ALTER TABLE ventes DROP FOREIGN KEY FK_64EC489A858C065E');
        $this->addSql('ALTER TABLE ventes DROP FOREIGN KEY FK_64EC489A20096AE3');
        $this->addSql('DROP TABLE achats');
        $this->addSql('DROP TABLE caracteristiques');
        $this->addSql('DROP TABLE categories');
        $this->addSql('DROP TABLE depenses');
        $this->addSql('DROP TABLE fournisseurs');
        $this->addSql('DROP TABLE lignes_achat');
        $this->addSql('DROP TABLE lignes_vente');
        $this->addSql('DROP TABLE logs_activite');
        $this->addSql('DROP TABLE magasins');
        $this->addSql('DROP TABLE mouvements_stock');
        $this->addSql('DROP TABLE produits');
        $this->addSql('DROP TABLE users');
        $this->addSql('DROP TABLE ventes');
    }
}
