<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251203013905 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE sous_categories (id INT AUTO_INCREMENT NOT NULL, categorie_id INT NOT NULL, magasin_id INT NOT NULL, nom VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, date_creation DATETIME NOT NULL, INDEX IDX_DC8B1382BCF5E72D (categorie_id), INDEX IDX_DC8B138220096AE3 (magasin_id), UNIQUE INDEX unique_nom_categorie (nom, categorie_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE sous_categories ADD CONSTRAINT FK_DC8B1382BCF5E72D FOREIGN KEY (categorie_id) REFERENCES categories (id)');
        $this->addSql('ALTER TABLE sous_categories ADD CONSTRAINT FK_DC8B138220096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE caracteristiques ADD sous_categorie_id INT DEFAULT NULL, ADD magasin_id INT NOT NULL, CHANGE categorie_id categorie_id INT DEFAULT NULL, CHANGE valeurs_possibles valeurs_possibles JSON DEFAULT NULL');
        $this->addSql('ALTER TABLE caracteristiques ADD CONSTRAINT FK_61B5DA1D365BF48 FOREIGN KEY (sous_categorie_id) REFERENCES sous_categories (id)');
        $this->addSql('ALTER TABLE caracteristiques ADD CONSTRAINT FK_61B5DA1D20096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('CREATE INDEX IDX_61B5DA1D365BF48 ON caracteristiques (sous_categorie_id)');
        $this->addSql('CREATE INDEX IDX_61B5DA1D20096AE3 ON caracteristiques (magasin_id)');
        $this->addSql('ALTER TABLE produits ADD sous_categorie_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE produits ADD CONSTRAINT FK_BE2DDF8C365BF48 FOREIGN KEY (sous_categorie_id) REFERENCES sous_categories (id)');
        $this->addSql('CREATE INDEX IDX_BE2DDF8C365BF48 ON produits (sous_categorie_id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE caracteristiques DROP FOREIGN KEY FK_61B5DA1D365BF48');
        $this->addSql('ALTER TABLE produits DROP FOREIGN KEY FK_BE2DDF8C365BF48');
        $this->addSql('ALTER TABLE sous_categories DROP FOREIGN KEY FK_DC8B1382BCF5E72D');
        $this->addSql('ALTER TABLE sous_categories DROP FOREIGN KEY FK_DC8B138220096AE3');
        $this->addSql('DROP TABLE sous_categories');
        $this->addSql('ALTER TABLE caracteristiques DROP FOREIGN KEY FK_61B5DA1D20096AE3');
        $this->addSql('DROP INDEX IDX_61B5DA1D365BF48 ON caracteristiques');
        $this->addSql('DROP INDEX IDX_61B5DA1D20096AE3 ON caracteristiques');
        $this->addSql('ALTER TABLE caracteristiques DROP sous_categorie_id, DROP magasin_id, CHANGE categorie_id categorie_id INT NOT NULL, CHANGE valeurs_possibles valeurs_possibles LONGTEXT DEFAULT NULL');
        $this->addSql('DROP INDEX IDX_BE2DDF8C365BF48 ON produits');
        $this->addSql('ALTER TABLE produits DROP sous_categorie_id');
    }
}
