<?php

namespace App\Controller;

use App\Entity\Depense;
use App\Form\DepenseType;
use App\Repository\DepenseRepository;
use App\Service\LogService;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/depenses', name: 'depenses_')]
#[IsGranted('ROLE_USER')]
class DepenseController extends AbstractController
{
    #[Route('', name: 'index', methods: ['GET'])]
    public function index(DepenseRepository $depenseRepository, Request $request): Response
    {
        $user = $this->getUser();
        $magasin = $user->getMagasin();

        $dateDebut = $request->query->get('date_debut') ? new \DateTime($request->query->get('date_debut')) : new \DateTime('first day of this month');
        $dateFin = $request->query->get('date_fin') ? new \DateTime($request->query->get('date_fin')) : new \DateTime('now');

        $depenses = $depenseRepository->findDepensesByMagasinAndDate($magasin, $dateDebut, $dateFin);

        return $this->render('depense/index.html.twig', [
            'depenses' => $depenses,
            'dateDebut' => $dateDebut,
            'dateFin' => $dateFin,
        ]);
    }

    #[Route('/new', name: 'new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $em, LogService $logService): Response
    {
        $user = $this->getUser();
        $magasin = $user->getMagasin();

        $depense = new Depense();
        $depense->setMagasin($magasin);
        $depense->setUtilisateur($user);

        $form = $this->createForm(DepenseType::class, $depense);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em->persist($depense);
            $em->flush();

            $logService->log($user, $magasin, 'Création dépense', 'Depense', $depense->getId(), "Dépense: {$depense->getLibelle()} - {$depense->getMontant()}");

            return $this->redirectToRoute('depenses_index');
        }

        return $this->render('depense/new.html.twig', [
            'depense' => $depense,
            'form' => $form,
        ]);
    }
}

