<?php

namespace App\Form;

use App\Entity\Depense;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\File;

class DepenseType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('libelle', TextType::class)
            ->add('categorie', ChoiceType::class, [
                'choices' => [
                    'Achat stock' => Depense::CATEGORIE_ACHAT_STOCK,
                    'Loyer' => Depense::CATEGORIE_LOYER,
                    'Salaires' => Depense::CATEGORIE_SALAIRES,
                    'Transport' => Depense::CATEGORIE_TRANSPORT,
                    'Divers' => Depense::CATEGORIE_DIVERS,
                ],
            ])
            ->add('montant', MoneyType::class, [
                'currency' => 'EUR',
                'scale' => 2,
            ])
            ->add('dateDepense', DateType::class, [
                'widget' => 'single_text',
            ])
            ->add('justificatif', FileType::class, [
                'required' => false,
                'mapped' => false,
                'constraints' => [
                    new File([
                        'maxSize' => '5M',
                        'mimeTypes' => ['application/pdf', 'image/jpeg', 'image/png'],
                    ]),
                ],
            ])
            ->add('notes', TextareaType::class, ['required' => false]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Depense::class,
        ]);
    }
}

