<?php

namespace App\Repository;

use App\Entity\Client;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Client>
 */
class ClientRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Client::class);
    }

    public function findByMagasin($magasin, ?string $search = null, bool $avecCredit = false): array
    {
        $qb = $this->createQueryBuilder('c')
            ->where('c.magasin = :magasin')
            ->setParameter('magasin', $magasin);

        if ($search) {
            $qb->andWhere('c.nom LIKE :search OR c.telephone LIKE :search OR c.cin LIKE :search OR c.email LIKE :search')
                ->setParameter('search', '%' . $search . '%');
        }

        if ($avecCredit) {
            $qb->join('c.ventes', 'v')
                ->andWhere('v.montantRestant > 0')
                ->andWhere('v.retour = false');
        }

        return $qb->orderBy('c.nom', 'ASC')
            ->getQuery()
            ->getResult();
    }

//    /**
//     * @return Client[] Returns an array of Client objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('c')
//            ->andWhere('c.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('c.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?Client
//    {
//        return $this->createQueryBuilder('c')
//            ->andWhere('c.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
