<?php

namespace App\Repository;

use App\Entity\Depense;
use App\Entity\Magasin;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class DepenseRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Depense::class);
    }

    public function findDepensesByMagasinAndDate(Magasin $magasin, \DateTime $dateDebut, \DateTime $dateFin): array
    {
        return $this->createQueryBuilder('d')
            ->where('d.magasin = :magasin')
            ->andWhere('d.dateDepense BETWEEN :dateDebut AND :dateFin')
            ->setParameter('magasin', $magasin)
            ->setParameter('dateDebut', $dateDebut)
            ->setParameter('dateFin', $dateFin)
            ->orderBy('d.dateDepense', 'DESC')
            ->getQuery()
            ->getResult();
    }
}

