<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* depense/index.html.twig */
class __TwigTemplate_15c55fc771679b459a3618d1fc58d79d extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "depense/index.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "depense/index.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Dépenses - Stock Manager";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Dépenses";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "    <div class=\"d-flex justify-content-between align-items-center mb-4\">
        <div>
            <p class=\"text-muted mb-0\" style=\"font-size: 0.875rem;\">Suivez vos dépenses</p>
        </div>
        <a href=\"";
        // line 11
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("depenses_new");
        yield "\" class=\"btn btn-primary\">
            <i class=\"bi bi-plus\"></i> Nouvelle dépense
        </a>
    </div>

    <!-- Filters -->
    <div class=\"card mb-4\">
        <form method=\"get\" class=\"row g-3\">
            <div class=\"col-md-5\">
                <label class=\"form-label\">Date début</label>
                <input type=\"date\" name=\"date_debut\" class=\"form-control\" value=\"";
        // line 21
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate((isset($context["dateDebut"]) || array_key_exists("dateDebut", $context) ? $context["dateDebut"] : (function () { throw new RuntimeError('Variable "dateDebut" does not exist.', 21, $this->source); })()), "Y-m-d"), "html", null, true);
        yield "\">
            </div>
            <div class=\"col-md-5\">
                <label class=\"form-label\">Date fin</label>
                <input type=\"date\" name=\"date_fin\" class=\"form-control\" value=\"";
        // line 25
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate((isset($context["dateFin"]) || array_key_exists("dateFin", $context) ? $context["dateFin"] : (function () { throw new RuntimeError('Variable "dateFin" does not exist.', 25, $this->source); })()), "Y-m-d"), "html", null, true);
        yield "\">
            </div>
            <div class=\"col-md-2 d-flex align-items-end\">
                <button type=\"submit\" class=\"btn btn-primary w-100\">
                    <i class=\"bi bi-funnel\"></i> Filtrer
                </button>
            </div>
        </form>
    </div>

    <!-- Expenses Table -->
    <div class=\"card\">
        <div class=\"table-responsive\">
            <table class=\"table mb-0\">
                <thead>
                    <tr>
                        <th>Libellé</th>
                        <th>Catégorie</th>
                        <th>Montant</th>
                        <th>Date</th>
                        <th>Utilisateur</th>
                    </tr>
                </thead>
                <tbody>
                    ";
        // line 49
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable((isset($context["depenses"]) || array_key_exists("depenses", $context) ? $context["depenses"] : (function () { throw new RuntimeError('Variable "depenses" does not exist.', 49, $this->source); })()));
        $context['_iterated'] = false;
        foreach ($context['_seq'] as $context["_key"] => $context["depense"]) {
            // line 50
            yield "                    <tr>
                        <td><strong>";
            // line 51
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "libelle", [], "any", false, false, false, 51), "html", null, true);
            yield "</strong></td>
                        <td><span class=\"badge\" style=\"background: var(--bg-tertiary); color: var(--text-secondary);\">";
            // line 52
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "categorie", [], "any", false, false, false, 52), "html", null, true);
            yield "</span></td>
                        <td><strong style=\"color: var(--danger);\">";
            // line 53
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "montant", [], "any", false, false, false, 53), 2, ",", " "), "html", null, true);
            yield " MAD</strong></td>
                        <td>";
            // line 54
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "dateDepense", [], "any", false, false, false, 54), "d/m/Y"), "html", null, true);
            yield "</td>
                        <td>";
            // line 55
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "utilisateur", [], "any", false, false, false, 55), "getFullName", [], "method", false, false, false, 55), "html", null, true);
            yield "</td>
                    </tr>
                    ";
            $context['_iterated'] = true;
        }
        // line 57
        if (!$context['_iterated']) {
            // line 58
            yield "                    <tr>
                        <td colspan=\"5\" class=\"text-center py-5\">
                            <div class=\"empty-state\">
                                <i class=\"bi bi-inbox\"></i>
                                <h5>Aucune dépense enregistrée</h5>
                            </div>
                        </td>
                    </tr>
                    ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['depense'], $context['_parent'], $context['_iterated']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 67
        yield "                </tbody>
            </table>
        </div>
    </div>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "depense/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  224 => 67,  210 => 58,  208 => 57,  201 => 55,  197 => 54,  193 => 53,  189 => 52,  185 => 51,  182 => 50,  177 => 49,  150 => 25,  143 => 21,  130 => 11,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Dépenses - Stock Manager{% endblock %}
{% block page_title %}Dépenses{% endblock %}

{% block content %}
    <div class=\"d-flex justify-content-between align-items-center mb-4\">
        <div>
            <p class=\"text-muted mb-0\" style=\"font-size: 0.875rem;\">Suivez vos dépenses</p>
        </div>
        <a href=\"{{ path('depenses_new') }}\" class=\"btn btn-primary\">
            <i class=\"bi bi-plus\"></i> Nouvelle dépense
        </a>
    </div>

    <!-- Filters -->
    <div class=\"card mb-4\">
        <form method=\"get\" class=\"row g-3\">
            <div class=\"col-md-5\">
                <label class=\"form-label\">Date début</label>
                <input type=\"date\" name=\"date_debut\" class=\"form-control\" value=\"{{ dateDebut|date('Y-m-d') }}\">
            </div>
            <div class=\"col-md-5\">
                <label class=\"form-label\">Date fin</label>
                <input type=\"date\" name=\"date_fin\" class=\"form-control\" value=\"{{ dateFin|date('Y-m-d') }}\">
            </div>
            <div class=\"col-md-2 d-flex align-items-end\">
                <button type=\"submit\" class=\"btn btn-primary w-100\">
                    <i class=\"bi bi-funnel\"></i> Filtrer
                </button>
            </div>
        </form>
    </div>

    <!-- Expenses Table -->
    <div class=\"card\">
        <div class=\"table-responsive\">
            <table class=\"table mb-0\">
                <thead>
                    <tr>
                        <th>Libellé</th>
                        <th>Catégorie</th>
                        <th>Montant</th>
                        <th>Date</th>
                        <th>Utilisateur</th>
                    </tr>
                </thead>
                <tbody>
                    {% for depense in depenses %}
                    <tr>
                        <td><strong>{{ depense.libelle }}</strong></td>
                        <td><span class=\"badge\" style=\"background: var(--bg-tertiary); color: var(--text-secondary);\">{{ depense.categorie }}</span></td>
                        <td><strong style=\"color: var(--danger);\">{{ depense.montant|number_format(2, ',', ' ') }} MAD</strong></td>
                        <td>{{ depense.dateDepense|date('d/m/Y') }}</td>
                        <td>{{ depense.utilisateur.getFullName() }}</td>
                    </tr>
                    {% else %}
                    <tr>
                        <td colspan=\"5\" class=\"text-center py-5\">
                            <div class=\"empty-state\">
                                <i class=\"bi bi-inbox\"></i>
                                <h5>Aucune dépense enregistrée</h5>
                            </div>
                        </td>
                    </tr>
                    {% endfor %}
                </tbody>
            </table>
        </div>
    </div>
{% endblock %}
", "depense/index.html.twig", "/var/www/html/templates/depense/index.html.twig");
    }
}
