<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* produit/show.html.twig */
class __TwigTemplate_e2fec94d56da2059cbfe71a6165c701b extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "produit/show.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "produit/show.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 3, $this->source); })()), "nom", [], "any", false, false, false, 3), "html", null, true);
        yield " - Stock Manager";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 4, $this->source); })()), "nom", [], "any", false, false, false, 4), "html", null, true);
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<div class=\"fade-in\">
    <div class=\"row\">
        <div class=\"col-lg-8\">
            <div class=\"stat-card mb-4\">
                <div class=\"d-flex justify-content-between align-items-start mb-4\">
                    <div>
                        <span class=\"badge bg-";
        // line 13
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 13, $this->source); })()), "statut", [], "any", false, false, false, 13) == "en_stock")) ? ("success") : ("warning"));
        yield " badge-modern mb-2\">
                            ";
        // line 14
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::titleCase($this->env->getCharset(), Twig\Extension\CoreExtension::replace(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 14, $this->source); })()), "statut", [], "any", false, false, false, 14), ["_" => " "])), "html", null, true);
        yield "
                        </span>
                        <h4 class=\"fw-bold mb-2\">";
        // line 16
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 16, $this->source); })()), "nom", [], "any", false, false, false, 16), "html", null, true);
        yield "</h4>
                        <p class=\"text-muted mb-0\">";
        // line 17
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 17, $this->source); })()), "categorie", [], "any", false, false, false, 17), "nom", [], "any", false, false, false, 17), "html", null, true);
        yield "</p>
                    </div>
                    <div class=\"d-flex gap-2\">
                        <a href=\"";
        // line 20
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("produits_imprimer_code_barres", ["id" => CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 20, $this->source); })()), "id", [], "any", false, false, false, 20)]), "html", null, true);
        yield "\" class=\"btn btn-outline-primary btn-modern\" target=\"_blank\">
                            <i class=\"bi bi-printer\"></i> Imprimer code-barres
                        </a>
                        ";
        // line 23
        if ((($tmp = $this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_MANAGER")) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 24
            yield "                        <a href=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("produits_edit", ["id" => CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 24, $this->source); })()), "id", [], "any", false, false, false, 24)]), "html", null, true);
            yield "\" class=\"btn btn-primary-modern btn-modern\">
                            <i class=\"bi bi-pencil\"></i> Modifier
                        </a>
                        ";
        }
        // line 28
        yield "                    </div>
                </div>

                ";
        // line 31
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 31, $this->source); })()), "description", [], "any", false, false, false, 31)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 32
            yield "                <div class=\"mb-4\">
                    <h6 class=\"fw-bold mb-2\">Description</h6>
                    <p class=\"text-muted\">";
            // line 34
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 34, $this->source); })()), "description", [], "any", false, false, false, 34), "html", null, true);
            yield "</p>
                </div>
                ";
        }
        // line 37
        yield "
                <div class=\"row g-4\">
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Stock disponible</div>
                            <div class=\"h4 fw-bold ";
        // line 42
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 42, $this->source); })()), "quantite", [], "any", false, false, false, 42) < 5)) ? ("text-danger") : ("text-success"));
        yield "\">
                                ";
        // line 43
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 43, $this->source); })()), "quantite", [], "any", false, false, false, 43), "html", null, true);
        yield " unités
                            </div>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Prix d'achat</div>
                            <div class=\"h4 fw-bold\">";
        // line 50
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 50, $this->source); })()), "prixAchat", [], "any", false, false, false, 50), 2, ",", " "), "html", null, true);
        yield " MAD</div>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Prix de vente</div>
                            <div class=\"h4 fw-bold text-primary\">";
        // line 56
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 56, $this->source); })()), "prixVente", [], "any", false, false, false, 56), 2, ",", " "), "html", null, true);
        yield " MAD</div>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Marge</div>
                            <div class=\"h4 fw-bold text-success\">
                                ";
        // line 63
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 63, $this->source); })()), "marge", [], "any", false, false, false, 63), 2, ",", " "), "html", null, true);
        yield " MAD
                                <small class=\"text-muted\">(";
        // line 64
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 64, $this->source); })()), "margePourcentage", [], "any", false, false, false, 64), 1), "html", null, true);
        yield "%)</small>
                            </div>
                        </div>
                    </div>
                </div>

                <hr class=\"my-4\">

                <div class=\"row g-3\">
                    <div class=\"col-md-6\">
                        <strong>Référence interne:</strong>
                        <code class=\"d-block mt-1 p-2 bg-light rounded\">";
        // line 75
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 75, $this->source); })()), "referenceInterne", [], "any", false, false, false, 75), "html", null, true);
        yield "</code>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Code-barres:</strong>
                        <div class=\"mt-2\">
                            <code class=\"d-block p-2 bg-light rounded mb-2\" style=\"font-family: monospace; font-size: 1.1rem;\">";
        // line 80
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 80, $this->source); })()), "codeBarres", [], "any", false, false, false, 80), "html", null, true);
        yield "</code>
                            <svg id=\"barcode-display\" style=\"max-width: 100%; height: auto;\"></svg>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Fournisseur:</strong>
                        <p class=\"mb-0 mt-1\">";
        // line 86
        yield (((($tmp = CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 86, $this->source); })()), "fournisseur", [], "any", false, false, false, 86)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 86, $this->source); })()), "fournisseur", [], "any", false, false, false, 86), "nom", [], "any", false, false, false, 86), "html", null, true)) : ("Aucun"));
        yield "</p>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Date d'entrée:</strong>
                        <p class=\"mb-0 mt-1\">";
        // line 90
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 90, $this->source); })()), "dateEntree", [], "any", false, false, false, 90), "d/m/Y"), "html", null, true);
        yield "</p>
                    </div>
                </div>
            </div>
        </div>
        <div class=\"col-lg-4\">
            <div class=\"stat-card\">
                <h6 class=\"fw-bold mb-3\">Actions rapides</h6>
                <div class=\"d-grid gap-2\">
                    <a href=\"";
        // line 99
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("produits_index");
        yield "\" class=\"btn btn-outline-secondary\">
                        <i class=\"bi bi-arrow-left\"></i> Retour à la liste
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const codeBarres = '";
        // line 110
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 110, $this->source); })()), "codeBarres", [], "any", false, false, false, 110), "html", null, true);
        yield "';
    if (codeBarres && typeof JsBarcode !== 'undefined') {
        try {
            JsBarcode(\"#barcode-display\", codeBarres, {
                format: \"EAN13\",
                width: 2,
                height: 60,
                displayValue: true,
                fontSize: 14,
                margin: 10
            });
        } catch (e) {
            console.error('Erreur génération code-barres:', e);
        }
    }
});
</script>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "produit/show.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  293 => 110,  279 => 99,  267 => 90,  260 => 86,  251 => 80,  243 => 75,  229 => 64,  225 => 63,  215 => 56,  206 => 50,  196 => 43,  192 => 42,  185 => 37,  179 => 34,  175 => 32,  173 => 31,  168 => 28,  160 => 24,  158 => 23,  152 => 20,  146 => 17,  142 => 16,  137 => 14,  133 => 13,  125 => 7,  112 => 6,  89 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}{{ produit.nom }} - Stock Manager{% endblock %}
{% block page_title %}{{ produit.nom }}{% endblock %}

{% block content %}
<div class=\"fade-in\">
    <div class=\"row\">
        <div class=\"col-lg-8\">
            <div class=\"stat-card mb-4\">
                <div class=\"d-flex justify-content-between align-items-start mb-4\">
                    <div>
                        <span class=\"badge bg-{{ produit.statut == 'en_stock' ? 'success' : 'warning' }} badge-modern mb-2\">
                            {{ produit.statut|replace({'_': ' '})|title }}
                        </span>
                        <h4 class=\"fw-bold mb-2\">{{ produit.nom }}</h4>
                        <p class=\"text-muted mb-0\">{{ produit.categorie.nom }}</p>
                    </div>
                    <div class=\"d-flex gap-2\">
                        <a href=\"{{ path('produits_imprimer_code_barres', {'id': produit.id}) }}\" class=\"btn btn-outline-primary btn-modern\" target=\"_blank\">
                            <i class=\"bi bi-printer\"></i> Imprimer code-barres
                        </a>
                        {% if is_granted('ROLE_MANAGER') %}
                        <a href=\"{{ path('produits_edit', {'id': produit.id}) }}\" class=\"btn btn-primary-modern btn-modern\">
                            <i class=\"bi bi-pencil\"></i> Modifier
                        </a>
                        {% endif %}
                    </div>
                </div>

                {% if produit.description %}
                <div class=\"mb-4\">
                    <h6 class=\"fw-bold mb-2\">Description</h6>
                    <p class=\"text-muted\">{{ produit.description }}</p>
                </div>
                {% endif %}

                <div class=\"row g-4\">
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Stock disponible</div>
                            <div class=\"h4 fw-bold {{ produit.quantite < 5 ? 'text-danger' : 'text-success' }}\">
                                {{ produit.quantite }} unités
                            </div>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Prix d'achat</div>
                            <div class=\"h4 fw-bold\">{{ produit.prixAchat|number_format(2, ',', ' ') }} MAD</div>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Prix de vente</div>
                            <div class=\"h4 fw-bold text-primary\">{{ produit.prixVente|number_format(2, ',', ' ') }} MAD</div>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"border rounded p-3\">
                            <div class=\"text-muted small mb-1\">Marge</div>
                            <div class=\"h4 fw-bold text-success\">
                                {{ produit.marge|number_format(2, ',', ' ') }} MAD
                                <small class=\"text-muted\">({{ produit.margePourcentage|number_format(1) }}%)</small>
                            </div>
                        </div>
                    </div>
                </div>

                <hr class=\"my-4\">

                <div class=\"row g-3\">
                    <div class=\"col-md-6\">
                        <strong>Référence interne:</strong>
                        <code class=\"d-block mt-1 p-2 bg-light rounded\">{{ produit.referenceInterne }}</code>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Code-barres:</strong>
                        <div class=\"mt-2\">
                            <code class=\"d-block p-2 bg-light rounded mb-2\" style=\"font-family: monospace; font-size: 1.1rem;\">{{ produit.codeBarres }}</code>
                            <svg id=\"barcode-display\" style=\"max-width: 100%; height: auto;\"></svg>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Fournisseur:</strong>
                        <p class=\"mb-0 mt-1\">{{ produit.fournisseur ? produit.fournisseur.nom : 'Aucun' }}</p>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Date d'entrée:</strong>
                        <p class=\"mb-0 mt-1\">{{ produit.dateEntree|date('d/m/Y') }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class=\"col-lg-4\">
            <div class=\"stat-card\">
                <h6 class=\"fw-bold mb-3\">Actions rapides</h6>
                <div class=\"d-grid gap-2\">
                    <a href=\"{{ path('produits_index') }}\" class=\"btn btn-outline-secondary\">
                        <i class=\"bi bi-arrow-left\"></i> Retour à la liste
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const codeBarres = '{{ produit.codeBarres }}';
    if (codeBarres && typeof JsBarcode !== 'undefined') {
        try {
            JsBarcode(\"#barcode-display\", codeBarres, {
                format: \"EAN13\",
                width: 2,
                height: 60,
                displayValue: true,
                fontSize: 14,
                margin: 10
            });
        } catch (e) {
            console.error('Erreur génération code-barres:', e);
        }
    }
});
</script>
{% endblock %}
", "produit/show.html.twig", "/var/www/html/templates/produit/show.html.twig");
    }
}
