<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* produit/imprimer_code_barres.html.twig */
class __TwigTemplate_3bed21ccd1489d6bd2b6602a5e5d0e03 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "produit/imprimer_code_barres.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "produit/imprimer_code_barres.html.twig"));

        // line 1
        yield "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Code-barres - ";
        // line 6
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 6, $this->source); })()), "referenceInterne", [], "any", false, false, false, 6), "html", null, true);
        yield "</title>
    <script src=\"https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js\"></script>
    <style>
        @media print {
            body { margin: 0; padding: 0; }
            .no-print { display: none !important; }
            .barcode-container { 
                page-break-inside: avoid;
                margin: 0;
                padding: 20px;
            }
        }
        
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f5f5f5;
        }
        
        .barcode-container {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            max-width: 400px;
            margin: 0 auto;
            text-align: center;
        }
        
        .barcode-header {
            margin-bottom: 20px;
            border-bottom: 2px solid #2563eb;
            padding-bottom: 15px;
        }
        
        .barcode-header h2 {
            margin: 0;
            color: #2563eb;
            font-size: 1.5rem;
        }
        
        .barcode-info {
            margin: 20px 0;
            text-align: left;
        }
        
        .barcode-info-item {
            margin: 10px 0;
            padding: 8px;
            background: #f8fafc;
            border-radius: 4px;
        }
        
        .barcode-info-label {
            font-weight: 600;
            color: #475569;
            font-size: 0.875rem;
        }
        
        .barcode-info-value {
            color: #0f172a;
            font-size: 1rem;
            margin-top: 4px;
        }
        
        #barcode-svg {
            margin: 20px 0;
            max-width: 100%;
        }
        
        .barcode-footer {
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
            font-size: 0.875rem;
            color: #64748b;
        }
        
        .print-button {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: #2563eb;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
            transition: all 0.2s;
        }
        
        .print-button:hover {
            background: #1d4ed8;
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(37, 99, 235, 0.4);
        }
        
        .back-button {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: #64748b;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            box-shadow: 0 4px 12px rgba(100, 116, 139, 0.3);
            transition: all 0.2s;
        }
        
        .back-button:hover {
            background: #475569;
            transform: translateY(-2px);
            color: white;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class=\"barcode-container\">
        <div class=\"barcode-header\">
            <h2>Code-barres produit</h2>
        </div>
        
        <div class=\"barcode-info\">
            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Référence interne</div>
                <div class=\"barcode-info-value\">";
        // line 141
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 141, $this->source); })()), "referenceInterne", [], "any", false, false, false, 141), "html", null, true);
        yield "</div>
            </div>
            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Nom du produit</div>
                <div class=\"barcode-info-value\">";
        // line 145
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 145, $this->source); })()), "nom", [], "any", false, false, false, 145), "html", null, true);
        yield "</div>
            </div>
            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Code-barres</div>
                <div class=\"barcode-info-value\" style=\"font-family: monospace; font-size: 1.1rem;\">";
        // line 149
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 149, $this->source); })()), "codeBarres", [], "any", false, false, false, 149), "html", null, true);
        yield "</div>
            </div>
            ";
        // line 151
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 151, $this->source); })()), "sousCategorie", [], "any", false, false, false, 151)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 152
            yield "            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Catégorie</div>
                <div class=\"barcode-info-value\">";
            // line 154
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 154, $this->source); })()), "sousCategorie", [], "any", false, false, false, 154), "nom", [], "any", false, false, false, 154), "html", null, true);
            yield "</div>
            </div>
            ";
        }
        // line 157
        yield "        </div>
        
        <svg id=\"barcode-svg\"></svg>
        
        <div class=\"barcode-footer\">
            <div>Généré le ";
        // line 162
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate("now", "d/m/Y à H:i"), "html", null, true);
        yield "</div>
            <div style=\"margin-top: 5px;\">Stock Manager - Suivi et vente</div>
        </div>
    </div>
    
    <button class=\"print-button no-print\" onclick=\"window.print()\">
        <i class=\"bi bi-printer\"></i> Imprimer
    </button>
    
    <a href=\"";
        // line 171
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("produits_show", ["id" => CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 171, $this->source); })()), "id", [], "any", false, false, false, 171)]), "html", null, true);
        yield "\" class=\"back-button no-print\">
        <i class=\"bi bi-arrow-left\"></i> Retour
    </a>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const codeBarres = '";
        // line 177
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 177, $this->source); })()), "codeBarres", [], "any", false, false, false, 177), "html", null, true);
        yield "';
            if (codeBarres) {
                try {
                    JsBarcode(\"#barcode-svg\", codeBarres, {
                        format: \"EAN13\",
                        width: 2,
                        height: 80,
                        displayValue: true,
                        fontSize: 16,
                        margin: 15,
                        textMargin: 5
                    });
                } catch (e) {
                    console.error('Erreur génération code-barres:', e);
                    document.getElementById('barcode-svg').innerHTML = 
                        '<text x=\"50%\" y=\"50%\" text-anchor=\"middle\" fill=\"red\">Erreur génération code-barres</text>';
                }
            }
        });
    </script>
</body>
</html>

";
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "produit/imprimer_code_barres.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  252 => 177,  243 => 171,  231 => 162,  224 => 157,  218 => 154,  214 => 152,  212 => 151,  207 => 149,  200 => 145,  193 => 141,  55 => 6,  48 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Code-barres - {{ produit.referenceInterne }}</title>
    <script src=\"https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js\"></script>
    <style>
        @media print {
            body { margin: 0; padding: 0; }
            .no-print { display: none !important; }
            .barcode-container { 
                page-break-inside: avoid;
                margin: 0;
                padding: 20px;
            }
        }
        
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f5f5f5;
        }
        
        .barcode-container {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            max-width: 400px;
            margin: 0 auto;
            text-align: center;
        }
        
        .barcode-header {
            margin-bottom: 20px;
            border-bottom: 2px solid #2563eb;
            padding-bottom: 15px;
        }
        
        .barcode-header h2 {
            margin: 0;
            color: #2563eb;
            font-size: 1.5rem;
        }
        
        .barcode-info {
            margin: 20px 0;
            text-align: left;
        }
        
        .barcode-info-item {
            margin: 10px 0;
            padding: 8px;
            background: #f8fafc;
            border-radius: 4px;
        }
        
        .barcode-info-label {
            font-weight: 600;
            color: #475569;
            font-size: 0.875rem;
        }
        
        .barcode-info-value {
            color: #0f172a;
            font-size: 1rem;
            margin-top: 4px;
        }
        
        #barcode-svg {
            margin: 20px 0;
            max-width: 100%;
        }
        
        .barcode-footer {
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
            font-size: 0.875rem;
            color: #64748b;
        }
        
        .print-button {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: #2563eb;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
            transition: all 0.2s;
        }
        
        .print-button:hover {
            background: #1d4ed8;
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(37, 99, 235, 0.4);
        }
        
        .back-button {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: #64748b;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            box-shadow: 0 4px 12px rgba(100, 116, 139, 0.3);
            transition: all 0.2s;
        }
        
        .back-button:hover {
            background: #475569;
            transform: translateY(-2px);
            color: white;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class=\"barcode-container\">
        <div class=\"barcode-header\">
            <h2>Code-barres produit</h2>
        </div>
        
        <div class=\"barcode-info\">
            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Référence interne</div>
                <div class=\"barcode-info-value\">{{ produit.referenceInterne }}</div>
            </div>
            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Nom du produit</div>
                <div class=\"barcode-info-value\">{{ produit.nom }}</div>
            </div>
            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Code-barres</div>
                <div class=\"barcode-info-value\" style=\"font-family: monospace; font-size: 1.1rem;\">{{ produit.codeBarres }}</div>
            </div>
            {% if produit.sousCategorie %}
            <div class=\"barcode-info-item\">
                <div class=\"barcode-info-label\">Catégorie</div>
                <div class=\"barcode-info-value\">{{ produit.sousCategorie.nom }}</div>
            </div>
            {% endif %}
        </div>
        
        <svg id=\"barcode-svg\"></svg>
        
        <div class=\"barcode-footer\">
            <div>Généré le {{ \"now\"|date(\"d/m/Y à H:i\") }}</div>
            <div style=\"margin-top: 5px;\">Stock Manager - Suivi et vente</div>
        </div>
    </div>
    
    <button class=\"print-button no-print\" onclick=\"window.print()\">
        <i class=\"bi bi-printer\"></i> Imprimer
    </button>
    
    <a href=\"{{ path('produits_show', {'id': produit.id}) }}\" class=\"back-button no-print\">
        <i class=\"bi bi-arrow-left\"></i> Retour
    </a>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const codeBarres = '{{ produit.codeBarres }}';
            if (codeBarres) {
                try {
                    JsBarcode(\"#barcode-svg\", codeBarres, {
                        format: \"EAN13\",
                        width: 2,
                        height: 80,
                        displayValue: true,
                        fontSize: 16,
                        margin: 15,
                        textMargin: 5
                    });
                } catch (e) {
                    console.error('Erreur génération code-barres:', e);
                    document.getElementById('barcode-svg').innerHTML = 
                        '<text x=\"50%\" y=\"50%\" text-anchor=\"middle\" fill=\"red\">Erreur génération code-barres</text>';
                }
            }
        });
    </script>
</body>
</html>

", "produit/imprimer_code_barres.html.twig", "/var/www/html/templates/produit/imprimer_code_barres.html.twig");
    }
}
