# Application de Gestion de Stock Multi-Magasins

Application SaaS complète pour la gestion de stock, ventes, achats, fournisseurs et comptabilité pour magasins d'électronique.

## Fonctionnalités

- ✅ Gestion multi-magasins (multi-tenant)
- ✅ Gestion des catégories avec caractéristiques dynamiques
- ✅ Gestion complète du stock
- ✅ Système de code-barres automatique
- ✅ Gestion des ventes avec factures
- ✅ Gestion des fournisseurs
- ✅ Gestion des dépenses
- ✅ Tableau de bord avec statistiques
- ✅ Historique et traçabilité complète
- ✅ Système de rôles (Admin, Manager, Employé)

## Installation avec Docker

1. Cloner le projet
```bash
git clone <repository>
cd saasInfo
```

2. Lancer les conteneurs Docker
```bash
docker-compose up -d
```

3. Installer les dépendances Composer
```bash
docker-compose exec php composer install
```

4. Créer la base de données
```bash
docker-compose exec php php bin/console doctrine:database:create
docker-compose exec php php bin/console doctrine:migrations:migrate
```

5. Créer un utilisateur admin
```bash
docker-compose exec php php bin/console app:create-admin
```

## Accès

- Application: http://localhost:8080
- phpMyAdmin: http://localhost:8081

## Structure du projet

```
saasInfo/
├── config/          # Configuration Symfony
├── docker/           # Configuration Docker
├── public/           # Point d'entrée web
├── src/
│   ├── Controller/  # Contrôleurs
│   ├── Entity/      # Entités Doctrine
│   ├── Form/         # Formulaires Symfony
│   ├── Repository/   # Repositories
│   └── Service/      # Services métier
└── templates/       # Templates Twig
```

## Technologies

- Symfony 6.4
- Twig
- Doctrine ORM
- MySQL 8.0
- Docker & Docker Compose
- Bootstrap 5
- Chart.js

## Déploiement en Production

### Avec Docker

Pour déployer avec Docker, consultez le guide complet dans [DEPLOY.md](DEPLOY.md).

1. **Préparer l'environnement** :
   ```bash
   cp ENV_EXAMPLE.txt .env
   nano .env
   ```

2. **Lancer le script de déploiement** :
   ```bash
   ./deploy.sh
   ```

### SANS Docker (Installation directe)

Pour déployer directement sur le serveur sans Docker, consultez le guide complet dans [DEPLOY_SANS_DOCKER.md](DEPLOY_SANS_DOCKER.md).

1. **Installer les dépendances système** (PHP 8.2+, MySQL, Nginx)
2. **Configurer l'environnement** :
   ```bash
   cp ENV_EXAMPLE.txt .env
   nano .env
   ```

3. **Lancer le script de déploiement** :
   ```bash
   ./deploy-prod.sh
   ```

4. **Créer un utilisateur administrateur** :
   ```bash
   php bin/console app:create-admin
   ```

### Fichiers importants pour le déploiement

- `DEPLOY.md` - Guide de déploiement avec Docker
- `DEPLOY_SANS_DOCKER.md` - Guide de déploiement sans Docker
- `docker-compose.prod.yml` - Configuration Docker pour la production
- `Dockerfile.prod` - Dockerfile optimisé pour la production
- `deploy.sh` - Script de déploiement avec Docker
- `deploy-prod.sh` - Script de déploiement sans Docker
- `ENV_EXAMPLE.txt` - Exemple de variables d'environnement

## Licence

MIT

