<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251203014429 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        
        $table = $schema->getTable('caracteristiques');
        if (!$table->hasColumn('date_creation')) {
            // Ajouter date_creation avec valeur par défaut pour les enregistrements existants
            $this->addSql('ALTER TABLE caracteristiques ADD date_creation DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL');
        }
        
        // Nettoyer les doublons de catégories avant d'ajouter la contrainte unique
        // 1. Mettre à jour les produits pour qu'ils pointent vers la catégorie conservée (la plus petite id)
        $this->addSql('
            UPDATE produits p
            INNER JOIN categories c1 ON p.categorie_id = c1.id
            INNER JOIN categories c2 ON c1.nom = c2.nom AND c1.magasin_id = c2.magasin_id AND c1.id > c2.id
            SET p.categorie_id = c2.id
        ');
        
        // 2. Mettre à jour les sous-catégories
        $this->addSql('
            UPDATE sous_categories sc
            INNER JOIN categories c1 ON sc.categorie_id = c1.id
            INNER JOIN categories c2 ON c1.nom = c2.nom AND c1.magasin_id = c2.magasin_id AND c1.id > c2.id
            SET sc.categorie_id = c2.id
        ');
        
        // 3. Mettre à jour les caractéristiques
        $this->addSql('
            UPDATE caracteristiques car
            INNER JOIN categories c1 ON car.categorie_id = c1.id
            INNER JOIN categories c2 ON c1.nom = c2.nom AND c1.magasin_id = c2.magasin_id AND c1.id > c2.id
            SET car.categorie_id = c2.id
        ');
        
        // 4. Maintenant on peut supprimer les doublons (on garde le premier enregistrement)
        $this->addSql('
            DELETE c1 FROM categories c1
            INNER JOIN categories c2 
            WHERE c1.id > c2.id 
            AND c1.nom = c2.nom 
            AND c1.magasin_id = c2.magasin_id
        ');
        
        // Vérifier si l'index unique existe déjà
        $categoriesTable = $schema->getTable('categories');
        if (!$categoriesTable->hasIndex('unique_nom_magasin')) {
            // Maintenant on peut créer la contrainte unique
            $this->addSql('CREATE UNIQUE INDEX unique_nom_magasin ON categories (nom, magasin_id)');
        }
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE caracteristiques DROP date_creation');
        $this->addSql('DROP INDEX unique_nom_magasin ON categories');
    }
}
