<?php

namespace App\EventListener;

use App\Entity\User;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;

class UserListener
{
    public function __construct(
        private UserPasswordHasherInterface $passwordHasher
    ) {
    }

    public function preUpdate(PreUpdateEventArgs $args): void
    {
        $entity = $args->getObject();

        if (!$entity instanceof User) {
            return;
        }

        if ($args->hasChangedField('password')) {
            $newPassword = $args->getNewValue('password');
            if ($newPassword && !preg_match('/^\$2[ayb]\$.{56}$/', $newPassword)) {
                $hashedPassword = $this->passwordHasher->hashPassword($entity, $newPassword);
                $args->setNewValue('password', $hashedPassword);
            }
        }
    }
}

