<?php

namespace App\Repository;

use App\Entity\Caracteristique;
use App\Entity\Categorie;
use App\Entity\SousCategorie;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Caracteristique>
 */
class CaracteristiqueRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Caracteristique::class);
    }

    /**
     * Vérifie si une caractéristique avec ce nom existe déjà dans la catégorie
     */
    public function findOneByNomAndCategorie(string $nom, Categorie $categorie, ?int $excludeId = null): ?Caracteristique
    {
        $qb = $this->createQueryBuilder('c')
            ->andWhere('c.nom = :nom')
            ->andWhere('c.categorie = :categorie')
            ->setParameter('nom', $nom)
            ->setParameter('categorie', $categorie);

        if ($excludeId) {
            $qb->andWhere('c.id != :excludeId')
                ->setParameter('excludeId', $excludeId);
        }

        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
     * Vérifie si une caractéristique avec ce nom existe déjà dans la sous-catégorie
     */
    public function findOneByNomAndSousCategorie(string $nom, SousCategorie $sousCategorie, ?int $excludeId = null): ?Caracteristique
    {
        $qb = $this->createQueryBuilder('c')
            ->andWhere('c.nom = :nom')
            ->andWhere('c.sousCategorie = :sousCategorie')
            ->setParameter('nom', $nom)
            ->setParameter('sousCategorie', $sousCategorie);

        if ($excludeId) {
            $qb->andWhere('c.id != :excludeId')
                ->setParameter('excludeId', $excludeId);
        }

        return $qb->getQuery()->getOneOrNullResult();
    }
}
