<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* fournisseur/alertes.html.twig */
class __TwigTemplate_8c8534687044cd121252b79841f8b18e extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "fournisseur/alertes.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "fournisseur/alertes.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Alertes de paiements - Stock Manager";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Alertes de paiements";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<style>
    .alertes-container {
        padding: 2rem 0;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid var(--border);
    }
    
    .alerte-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        margin-bottom: 1rem;
        border-left: 4px solid;
        transition: all 0.3s ease;
    }
    
    .alerte-card.retard {
        border-left-color: #dc2626;
        background: linear-gradient(135deg, rgba(220, 38, 38, 0.05) 0%, rgba(239, 68, 68, 0.05) 100%);
    }
    
    .alerte-card.a_venir {
        border-left-color: #f59e0b;
        background: linear-gradient(135deg, rgba(245, 158, 11, 0.05) 0%, rgba(251, 191, 36, 0.05) 100%);
    }
    
    .alerte-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 1rem;
    }
    
    .alerte-type {
        font-weight: 600;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .alerte-type.retard {
        color: #dc2626;
    }
    
    .alerte-type.a_venir {
        color: #f59e0b;
    }
    
    .alerte-montant {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--text-primary);
    }
    
    .alerte-info {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-top: 1rem;
        padding-top: 1rem;
        border-top: 1px solid var(--border);
    }
    
    .info-item {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .info-label {
        font-size: 0.75rem;
        color: var(--text-secondary);
    }
    
    .info-value {
        font-weight: 500;
        color: var(--text-primary);
    }
</style>

<div class=\"alertes-container\">
    <div class=\"page-header\">
        <div>
            <h1>Alertes de paiements</h1>
            <p class=\"subtitle\" style=\"color: var(--text-secondary); margin-top: 0.5rem;\">Suivez les paiements à venir et en retard</p>
        </div>
        <a href=\"";
        // line 100
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_index");
        yield "\" class=\"btn btn-modern\" style=\"background: var(--bg-secondary); color: var(--text-primary); border: 1px solid var(--border);\">
            <i class=\"bi bi-arrow-left\"></i>
            Retour
        </a>
    </div>

    ";
        // line 106
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["alertes"]) || array_key_exists("alertes", $context) ? $context["alertes"] : (function () { throw new RuntimeError('Variable "alertes" does not exist.', 106, $this->source); })())) > 0)) {
            // line 107
            yield "    ";
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["alertes"]) || array_key_exists("alertes", $context) ? $context["alertes"] : (function () { throw new RuntimeError('Variable "alertes" does not exist.', 107, $this->source); })()));
            $context['loop'] = [
              'parent' => $context['_parent'],
              'index0' => 0,
              'index'  => 1,
              'first'  => true,
            ];
            if (is_array($context['_seq']) || (is_object($context['_seq']) && $context['_seq'] instanceof \Countable)) {
                $length = count($context['_seq']);
                $context['loop']['revindex0'] = $length - 1;
                $context['loop']['revindex'] = $length;
                $context['loop']['length'] = $length;
                $context['loop']['last'] = 1 === $length;
            }
            foreach ($context['_seq'] as $context["_key"] => $context["alerte"]) {
                // line 108
                yield "    <div class=\"alerte-card ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "type", [], "any", false, false, false, 108), "html", null, true);
                yield "\" data-aos=\"fade-up\" data-aos-delay=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((CoreExtension::getAttribute($this->env, $this->source, $context["loop"], "index0", [], "any", false, false, false, 108) * 50), "html", null, true);
                yield "\">
        <div class=\"alerte-header\">
            <div>
                <span class=\"alerte-type ";
                // line 111
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "type", [], "any", false, false, false, 111), "html", null, true);
                yield "\">";
                yield (((CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "type", [], "any", false, false, false, 111) == "retard")) ? ("En retard") : ("À venir"));
                yield "</span>
                <h3 style=\"margin: 0.5rem 0 0 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);\">
                    ";
                // line 113
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "fournisseur", [], "any", false, false, false, 113), "nom", [], "any", false, false, false, 113), "html", null, true);
                yield "
                </h3>
            </div>
            <div class=\"alerte-montant\">";
                // line 116
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "montant", [], "any", false, false, false, 116), 2, ",", " "), "html", null, true);
                yield " MAD</div>
        </div>
        
        <div class=\"alerte-info\">
            <div class=\"info-item\">
                <span class=\"info-label\">Facture</span>
                <span class=\"info-value\">";
                // line 122
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "achat", [], "any", false, false, false, 122), "numeroFacture", [], "any", false, false, false, 122), "html", null, true);
                yield "</span>
            </div>
            <div class=\"info-item\">
                <span class=\"info-label\">Date limite</span>
                <span class=\"info-value\">";
                // line 126
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "date", [], "any", false, false, false, 126), "d/m/Y"), "html", null, true);
                yield "</span>
            </div>
            ";
                // line 128
                if (CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "joursRestants", [], "any", true, true, false, 128)) {
                    // line 129
                    yield "            <div class=\"info-item\">
                <span class=\"info-label\">Jours restants</span>
                <span class=\"info-value\">";
                    // line 131
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "joursRestants", [], "any", false, false, false, 131), "html", null, true);
                    yield " jour(s)</span>
            </div>
            ";
                }
                // line 134
                yield "            <div class=\"info-item\">
                <a href=\"";
                // line 135
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_show", ["id" => CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "fournisseur", [], "any", false, false, false, 135), "id", [], "any", false, false, false, 135)]), "html", null, true);
                yield "\" class=\"btn btn-modern\" style=\"background: var(--primary); color: white; padding: 0.5rem 1rem; font-size: 0.875rem;\">
                    <i class=\"bi bi-eye\"></i>
                    Voir détails
                </a>
            </div>
        </div>
    </div>
    ";
                ++$context['loop']['index0'];
                ++$context['loop']['index'];
                $context['loop']['first'] = false;
                if (isset($context['loop']['revindex0'], $context['loop']['revindex'])) {
                    --$context['loop']['revindex0'];
                    --$context['loop']['revindex'];
                    $context['loop']['last'] = 0 === $context['loop']['revindex0'];
                }
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['alerte'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 143
            yield "    ";
        } else {
            // line 144
            yield "    <div style=\"text-align: center; padding: 4rem 2rem; background: white; border-radius: 1rem; border: 2px dashed var(--border);\">
        <i class=\"bi bi-check-circle\" style=\"font-size: 4rem; color: #16a34a; margin-bottom: 1rem;\"></i>
        <h3 style=\"font-size: 1.5rem; font-weight: 600; color: var(--text-primary); margin-bottom: 0.5rem;\">Aucune alerte</h3>
        <p style=\"color: var(--text-secondary);\">Tous les paiements sont à jour</p>
    </div>
    ";
        }
        // line 150
        yield "</div>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "fournisseur/alertes.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  339 => 150,  331 => 144,  328 => 143,  306 => 135,  303 => 134,  297 => 131,  293 => 129,  291 => 128,  286 => 126,  279 => 122,  270 => 116,  264 => 113,  257 => 111,  248 => 108,  230 => 107,  228 => 106,  219 => 100,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Alertes de paiements - Stock Manager{% endblock %}
{% block page_title %}Alertes de paiements{% endblock %}

{% block content %}
<style>
    .alertes-container {
        padding: 2rem 0;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid var(--border);
    }
    
    .alerte-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        margin-bottom: 1rem;
        border-left: 4px solid;
        transition: all 0.3s ease;
    }
    
    .alerte-card.retard {
        border-left-color: #dc2626;
        background: linear-gradient(135deg, rgba(220, 38, 38, 0.05) 0%, rgba(239, 68, 68, 0.05) 100%);
    }
    
    .alerte-card.a_venir {
        border-left-color: #f59e0b;
        background: linear-gradient(135deg, rgba(245, 158, 11, 0.05) 0%, rgba(251, 191, 36, 0.05) 100%);
    }
    
    .alerte-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 1rem;
    }
    
    .alerte-type {
        font-weight: 600;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .alerte-type.retard {
        color: #dc2626;
    }
    
    .alerte-type.a_venir {
        color: #f59e0b;
    }
    
    .alerte-montant {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--text-primary);
    }
    
    .alerte-info {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-top: 1rem;
        padding-top: 1rem;
        border-top: 1px solid var(--border);
    }
    
    .info-item {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .info-label {
        font-size: 0.75rem;
        color: var(--text-secondary);
    }
    
    .info-value {
        font-weight: 500;
        color: var(--text-primary);
    }
</style>

<div class=\"alertes-container\">
    <div class=\"page-header\">
        <div>
            <h1>Alertes de paiements</h1>
            <p class=\"subtitle\" style=\"color: var(--text-secondary); margin-top: 0.5rem;\">Suivez les paiements à venir et en retard</p>
        </div>
        <a href=\"{{ path('fournisseurs_index') }}\" class=\"btn btn-modern\" style=\"background: var(--bg-secondary); color: var(--text-primary); border: 1px solid var(--border);\">
            <i class=\"bi bi-arrow-left\"></i>
            Retour
        </a>
    </div>

    {% if alertes|length > 0 %}
    {% for alerte in alertes %}
    <div class=\"alerte-card {{ alerte.type }}\" data-aos=\"fade-up\" data-aos-delay=\"{{ loop.index0 * 50 }}\">
        <div class=\"alerte-header\">
            <div>
                <span class=\"alerte-type {{ alerte.type }}\">{{ alerte.type == 'retard' ? 'En retard' : 'À venir' }}</span>
                <h3 style=\"margin: 0.5rem 0 0 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);\">
                    {{ alerte.fournisseur.nom }}
                </h3>
            </div>
            <div class=\"alerte-montant\">{{ alerte.montant|number_format(2, ',', ' ') }} MAD</div>
        </div>
        
        <div class=\"alerte-info\">
            <div class=\"info-item\">
                <span class=\"info-label\">Facture</span>
                <span class=\"info-value\">{{ alerte.achat.numeroFacture }}</span>
            </div>
            <div class=\"info-item\">
                <span class=\"info-label\">Date limite</span>
                <span class=\"info-value\">{{ alerte.date|date('d/m/Y') }}</span>
            </div>
            {% if alerte.joursRestants is defined %}
            <div class=\"info-item\">
                <span class=\"info-label\">Jours restants</span>
                <span class=\"info-value\">{{ alerte.joursRestants }} jour(s)</span>
            </div>
            {% endif %}
            <div class=\"info-item\">
                <a href=\"{{ path('fournisseurs_show', {'id': alerte.fournisseur.id}) }}\" class=\"btn btn-modern\" style=\"background: var(--primary); color: white; padding: 0.5rem 1rem; font-size: 0.875rem;\">
                    <i class=\"bi bi-eye\"></i>
                    Voir détails
                </a>
            </div>
        </div>
    </div>
    {% endfor %}
    {% else %}
    <div style=\"text-align: center; padding: 4rem 2rem; background: white; border-radius: 1rem; border: 2px dashed var(--border);\">
        <i class=\"bi bi-check-circle\" style=\"font-size: 4rem; color: #16a34a; margin-bottom: 1rem;\"></i>
        <h3 style=\"font-size: 1.5rem; font-weight: 600; color: var(--text-primary); margin-bottom: 0.5rem;\">Aucune alerte</h3>
        <p style=\"color: var(--text-secondary);\">Tous les paiements sont à jour</p>
    </div>
    {% endif %}
</div>
{% endblock %}

", "fournisseur/alertes.html.twig", "/var/www/html/templates/fournisseur/alertes.html.twig");
    }
}
