<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* base.html.twig */
class __TwigTemplate_7684cf99b10b968d09150d2c2f0f3015 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'stylesheets' => [$this, 'block_stylesheets'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
            'content_login' => [$this, 'block_content_login'],
            'javascripts' => [$this, 'block_javascripts'],
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "base.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "base.html.twig"));

        // line 1
        yield "<!DOCTYPE html>
<html lang=\"fr\" class=\"h-100\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>";
        // line 6
        yield from $this->unwrap()->yieldBlock('title', $context, $blocks);
        yield "</title>
    
    <!-- Bootstrap 5 -->
    <link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css\" rel=\"stylesheet\">
    <!-- Bootstrap Icons -->
    <link rel=\"stylesheet\" href=\"https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css\">
    <!-- Google Fonts -->
    <link rel=\"preconnect\" href=\"https://fonts.googleapis.com\">
    <link rel=\"preconnect\" href=\"https://fonts.gstatic.com\" crossorigin>
    <link href=\"https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap\" rel=\"stylesheet\">
    <!-- Chart.js -->
    <script src=\"https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js\"></script>
    <!-- JsBarcode for barcode generation -->
    <script src=\"https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js\"></script>
    <!-- AOS Animation -->
    <link href=\"https://unpkg.com/aos@2.3.1/dist/aos.css\" rel=\"stylesheet\">
    <script src=\"https://unpkg.com/aos@2.3.1/dist/aos.js\"></script>
    
    <style>
        :root {
            --primary: #dc2626;
            --primary-hover: #b91c1c;
            --primary-light: #ef4444;
            --secondary: #1f2937;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #dc2626;
            --bg-primary: #ffffff;
            --bg-secondary: #f9fafb;
            --bg-tertiary: #f3f4f6;
            --border: #e5e7eb;
            --text-primary: #000000;
            --text-secondary: #1f2937;
            --text-tertiary: #6b7280;
            --sidebar-width: 260px;
            --header-height: 64px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: var(--bg-secondary);
            color: var(--text-primary);
            line-height: 1.6;
            font-size: 14px;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        /* Sidebar - Style moderne */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: var(--bg-primary);
            border-right: 1px solid var(--border);
            z-index: 1000;
            overflow-y: auto;
            transition: all 0.3s ease;
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 3px;
        }

        .sidebar-header {
            padding: 1.5rem 1.25rem;
            border-bottom: 1px solid var(--border);
            height: var(--header-height);
            display: flex;
            align-items: center;
        }

        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-size: 1.125rem;
            font-weight: 700;
            color: var(--text-primary);
            text-decoration: none;
        }

        .sidebar-logo i {
            font-size: 1.5rem;
            color: var(--primary);
        }
        
        .sidebar-logo span {
            background: linear-gradient(135deg, var(--primary) 0%, #000000 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-weight: 800;
            letter-spacing: -0.5px;
        }

        .sidebar-nav {
            padding: 0.75rem;
        }

        .nav-item {
            margin-bottom: 0.25rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.625rem 0.875rem;
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: 0.5rem;
            transition: all 0.2s ease;
            font-weight: 500;
            font-size: 0.875rem;
        }

        .nav-link:hover {
            background: var(--bg-tertiary);
            color: var(--text-primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .nav-link i {
            font-size: 1.125rem;
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            transition: margin-left 0.3s ease;
            display: flex;
            flex-direction: column;
        }

        /* Header */
        .topbar {
            background: var(--bg-primary);
            height: var(--header-height);
            padding: 0 2rem;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .page-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0;
        }

        .topbar-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .topbar-icon {
            width: 36px;
            height: 36px;
            border-radius: 0.5rem;
            background: var(--bg-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--text-secondary);
            cursor: pointer;
            transition: all 0.2s ease;
            position: relative;
        }

        .topbar-icon:hover {
            background: var(--bg-tertiary);
            color: var(--text-primary);
        }

        .topbar-icon .badge {
            position: absolute;
            top: -4px;
            right: -4px;
            background: var(--danger);
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid var(--bg-primary);
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.375rem 0.5rem;
            border-radius: 0.5rem;
            cursor: pointer;
            transition: background 0.2s ease;
        }

        .user-profile:hover {
            background: var(--bg-secondary);
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 0.5rem;
            background: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 0.75rem;
        }

        .user-info {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 500;
            font-size: 0.875rem;
            color: var(--text-primary);
            line-height: 1.2;
        }

        .user-role {
            font-size: 0.75rem;
            color: var(--text-tertiary);
            line-height: 1.2;
        }

        /* Content Area */
        .content-area {
            padding: 2rem;
            flex: 1;
            overflow-y: auto;
        }

        /* Cards */
        .card {
            background: var(--bg-primary);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            transition: all 0.2s ease;
        }

        .card:hover {
            border-color: var(--primary);
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.08);
        }

        /* Product Card */
        .product-card {
            background: var(--bg-primary);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.25rem;
            transition: all 0.2s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .product-card:hover {
            border-color: var(--primary);
            box-shadow: 0 8px 24px rgba(220, 38, 38, 0.12);
            transform: translateY(-2px);
        }

        .product-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }

        .product-title {
            font-size: 1rem;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0 0 0.5rem 0;
        }

        .product-badges {
            display: flex;
            gap: 0.5rem;
            flex-wrap: wrap;
            margin-bottom: 1rem;
        }

        .badge {
            padding: 0.25rem 0.625rem;
            border-radius: 0.375rem;
            font-size: 0.75rem;
            font-weight: 500;
        }

        .badge-category {
            background: var(--bg-tertiary);
            color: var(--text-secondary);
        }

        .badge-state {
            background: var(--success);
            color: white;
        }

        .badge-state.warning {
            background: var(--warning);
        }

        .product-info {
            flex-grow: 1;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px solid var(--border);
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-size: 0.875rem;
            color: var(--text-tertiary);
        }

        .info-value {
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .info-value.text-success {
            color: var(--success);
        }

        .info-value.text-danger {
            color: var(--danger);
        }

        .product-actions {
            display: flex;
            gap: 0.5rem;
            margin-top: 1rem;
            padding-top: 1rem;
            border-top: 1px solid var(--border);
        }

        /* Buttons */
        .btn {
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
            font-weight: 500;
            font-size: 0.875rem;
            transition: all 0.2s ease;
            border: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-hover);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
        }

        .btn-outline-primary {
            background: transparent;
            color: var(--primary);
            border: 1px solid var(--primary);
        }

        .btn-outline-primary:hover {
            background: var(--primary);
            color: white;
        }

        .btn-sm {
            padding: 0.375rem 0.75rem;
            font-size: 0.8125rem;
        }
        
        .btn-primary-modern {
            background: var(--primary);
            color: white;
            font-weight: 600;
            border: none;
        }
        
        .btn-primary-modern:hover {
            background: var(--primary-hover);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
        }
        
        .btn-modern {
            border-radius: 0.5rem;
            transition: all 0.2s ease;
        }
        
        .card-modern {
            background: var(--bg-primary);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        
        .card-header-modern {
            padding: 1.25rem 1.5rem;
            border-bottom: 1px solid var(--border);
            background: var(--bg-secondary);
            border-radius: 0.75rem 0.75rem 0 0;
        }
        
        .card-body-modern {
            padding: 1.5rem;
        }

        /* Forms */
        .form-label {
            font-weight: 500;
            font-size: 0.875rem;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
        }

        .form-control,
        .form-select {
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            padding: 0.625rem 0.875rem;
            font-size: 0.875rem;
            transition: all 0.2s ease;
            background: var(--bg-primary);
        }

        .form-control:focus,
        .form-select:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        .input-group-text {
            background: var(--bg-secondary);
            border: 1px solid var(--border);
            border-right: none;
            color: var(--text-secondary);
        }

        /* Tables */
        .table {
            background: var(--bg-primary);
            border-radius: 0.75rem;
            overflow: hidden;
            border: 1px solid var(--border);
        }

        .table thead {
            background: var(--bg-secondary);
        }

        .table th {
            font-weight: 600;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: var(--text-secondary);
            padding: 0.875rem 1rem;
            border: none;
        }

        .table td {
            padding: 1rem;
            border-top: 1px solid var(--border);
            vertical-align: middle;
        }

        .table tbody tr {
            transition: background 0.2s ease;
        }

        .table tbody tr:hover {
            background: var(--bg-secondary);
        }

        /* Alerts */
        .alert {
            border-radius: 0.5rem;
            border: none;
            padding: 0.875rem 1rem;
            font-size: 0.875rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .main-content {
                margin-left: 0;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-in {
            animation: fadeIn 0.4s ease;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 4rem 2rem;
        }

        .empty-state i {
            font-size: 4rem;
            color: var(--text-tertiary);
            margin-bottom: 1rem;
        }

        .empty-state h5 {
            color: var(--text-secondary);
            margin-bottom: 0.5rem;
        }

        .empty-state p {
            color: var(--text-tertiary);
            margin-bottom: 1.5rem;
        }
    </style>
    
    ";
        // line 598
        yield from $this->unwrap()->yieldBlock('stylesheets', $context, $blocks);
        // line 599
        yield "</head>
<body>
    ";
        // line 601
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 601, $this->source); })()), "user", [], "any", false, false, false, 601)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 602
            yield "    <!-- Sidebar -->
    <aside class=\"sidebar\">
        <div class=\"sidebar-header\">
            <a href=\"/\" class=\"sidebar-logo\">
                <i class=\"bi bi-box-seam\"></i>
                <span style=\"color: var(--primary); font-weight: 800;\">Red Store</span>
            </a>
        </div>
        <nav class=\"sidebar-nav\">
            <div class=\"nav-item\">
                <a href=\"/\" class=\"nav-link ";
            // line 612
            yield ((((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 612, $this->source); })()), "request", [], "any", false, false, false, 612), "get", ["_route"], "method", false, false, false, 612) == "dashboard_index") || (CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 612, $this->source); })()), "request", [], "any", false, false, false, 612), "pathInfo", [], "any", false, false, false, 612) == "/"))) ? ("active") : (""));
            yield "\">
                    <i class=\"bi bi-speedometer2\"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"";
            // line 618
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("produits_index");
            yield "\" class=\"nav-link ";
            yield ((CoreExtension::inFilter("produits", CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 618, $this->source); })()), "request", [], "any", false, false, false, 618), "get", ["_route"], "method", false, false, false, 618))) ? ("active") : (""));
            yield "\">
                    <i class=\"bi bi-box\"></i>
                    <span>Produits</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"";
            // line 624
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_index");
            yield "\" class=\"nav-link ";
            yield ((CoreExtension::inFilter("ventes", CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 624, $this->source); })()), "request", [], "any", false, false, false, 624), "get", ["_route"], "method", false, false, false, 624))) ? ("active") : (""));
            yield "\">
                    <i class=\"bi bi-cart-check\"></i>
                    <span>Ventes</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"";
            // line 630
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_index");
            yield "\" class=\"nav-link ";
            yield ((CoreExtension::inFilter("fournisseurs", CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 630, $this->source); })()), "request", [], "any", false, false, false, 630), "get", ["_route"], "method", false, false, false, 630))) ? ("active") : (""));
            yield "\">
                    <i class=\"bi bi-truck\"></i>
                    <span>Fournisseurs</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"";
            // line 636
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("depenses_index");
            yield "\" class=\"nav-link ";
            yield ((CoreExtension::inFilter("depenses", CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 636, $this->source); })()), "request", [], "any", false, false, false, 636), "get", ["_route"], "method", false, false, false, 636))) ? ("active") : (""));
            yield "\">
                    <i class=\"bi bi-cash-stack\"></i>
                    <span>Dépenses</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"";
            // line 642
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("bilan_index");
            yield "\" class=\"nav-link ";
            yield ((CoreExtension::inFilter("bilan", CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 642, $this->source); })()), "request", [], "any", false, false, false, 642), "get", ["_route"], "method", false, false, false, 642))) ? ("active") : (""));
            yield "\">
                    <i class=\"bi bi-graph-up\"></i>
                    <span>Bilan</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"";
            // line 648
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("credits_index");
            yield "\" class=\"nav-link ";
            yield ((CoreExtension::inFilter("credits", CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 648, $this->source); })()), "request", [], "any", false, false, false, 648), "get", ["_route"], "method", false, false, false, 648))) ? ("active") : (""));
            yield "\">
                    <i class=\"bi bi-credit-card\"></i>
                    <span>Crédits</span>
                </a>
            </div>
            ";
            // line 653
            if ((($tmp = $this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_MANAGER")) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 654
                yield "            <div class=\"nav-item\">
                <a href=\"";
                // line 655
                yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("categories_index");
                yield "\" class=\"nav-link ";
                yield ((CoreExtension::inFilter("categories", CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 655, $this->source); })()), "request", [], "any", false, false, false, 655), "get", ["_route"], "method", false, false, false, 655))) ? ("active") : (""));
                yield "\">
                    <i class=\"bi bi-tags\"></i>
                    <span>Catégories</span>
                </a>
            </div>
            ";
            }
            // line 661
            yield "        </nav>
    </aside>

    <!-- Main Content -->
    <div class=\"main-content\">
        <!-- Top Bar -->
        <div class=\"topbar\">
            <h1 class=\"page-title\">";
            // line 668
            yield from $this->unwrap()->yieldBlock('page_title', $context, $blocks);
            yield "</h1>
            <div class=\"topbar-right\">
                <div class=\"topbar-icon\" data-bs-toggle=\"dropdown\">
                    <i class=\"bi bi-bell\"></i>
                    <span class=\"badge\">3</span>
                </div>
                <ul class=\"dropdown-menu dropdown-menu-end shadow-lg\" style=\"min-width: 300px; border-radius: 0.75rem; border: 1px solid var(--border);\">
                    <li><h6 class=\"dropdown-header\">Notifications</h6></li>
                    <li><hr class=\"dropdown-divider\"></li>
                    <li><a class=\"dropdown-item\" href=\"#\"><small class=\"text-muted\">12:47 pm</small><br>Stock faible détecté</a></li>
                    <li><a class=\"dropdown-item\" href=\"#\"><small class=\"text-muted\">11:30 pm</small><br>Nouvelle vente enregistrée</a></li>
                    <li><a class=\"dropdown-item\" href=\"#\"><small class=\"text-muted\">11:21 pm</small><br>Commande reçue</a></li>
                </ul>
                
                <div class=\"dropdown\">
                    <div class=\"user-profile\" data-bs-toggle=\"dropdown\">
                        <div class=\"user-avatar\">
                            ";
            // line 685
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::slice($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 685, $this->source); })()), "user", [], "any", false, false, false, 685), "prenom", [], "any", false, false, false, 685), 0, 1), "html", null, true);
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::slice($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 685, $this->source); })()), "user", [], "any", false, false, false, 685), "nom", [], "any", false, false, false, 685), 0, 1), "html", null, true);
            yield "
                        </div>
                        <div class=\"user-info\">
                            <div class=\"user-name\">";
            // line 688
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 688, $this->source); })()), "user", [], "any", false, false, false, 688), "getFullName", [], "method", false, false, false, 688), "html", null, true);
            yield "</div>
                            <div class=\"user-role\">";
            // line 689
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::replace(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 689, $this->source); })()), "user", [], "any", false, false, false, 689), "roles", [], "any", false, false, false, 689), 0, [], "array", false, false, false, 689), ["ROLE_" => ""]), "html", null, true);
            yield "</div>
                        </div>
                        <i class=\"bi bi-chevron-down\" style=\"font-size: 0.75rem; color: var(--text-tertiary);\"></i>
                    </div>
                    <ul class=\"dropdown-menu dropdown-menu-end shadow-lg\" style=\"border-radius: 0.75rem; border: 1px solid var(--border);\">
                        <li><h6 class=\"dropdown-header fw-bold\">";
            // line 694
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 694, $this->source); })()), "user", [], "any", false, false, false, 694), "getFullName", [], "method", false, false, false, 694), "html", null, true);
            yield "</h6></li>
                        <li><hr class=\"dropdown-divider\"></li>
                        <li><a class=\"dropdown-item\" href=\"";
            // line 696
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("logout");
            yield "\"><i class=\"bi bi-box-arrow-right\"></i> Déconnexion</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class=\"content-area fade-in\">
            ";
            // line 704
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 704, $this->source); })()), "flashes", ["success"], "method", false, false, false, 704));
            foreach ($context['_seq'] as $context["_key"] => $context["message"]) {
                // line 705
                yield "                <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                    <i class=\"bi bi-check-circle\"></i> ";
                // line 706
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["message"], "html", null, true);
                yield "
                    <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
                </div>
            ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['message'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 710
            yield "            ";
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 710, $this->source); })()), "flashes", ["error"], "method", false, false, false, 710));
            foreach ($context['_seq'] as $context["_key"] => $context["message"]) {
                // line 711
                yield "                <div class=\"alert alert-danger alert-dismissible fade show\" role=\"alert\">
                    <i class=\"bi bi-exclamation-circle\"></i> ";
                // line 712
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["message"], "html", null, true);
                yield "
                    <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
                </div>
            ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['message'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 716
            yield "            ";
            yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
            // line 717
            yield "        </div>
    </div>
    ";
        } else {
            // line 720
            yield "        ";
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 720, $this->source); })()), "flashes", ["success"], "method", false, false, false, 720));
            foreach ($context['_seq'] as $context["_key"] => $context["message"]) {
                // line 721
                yield "            <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                <i class=\"bi bi-check-circle\"></i> ";
                // line 722
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["message"], "html", null, true);
                yield "
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
            </div>
        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['message'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 726
            yield "        ";
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 726, $this->source); })()), "flashes", ["error"], "method", false, false, false, 726));
            foreach ($context['_seq'] as $context["_key"] => $context["message"]) {
                // line 727
                yield "            <div class=\"alert alert-danger alert-dismissible fade show\" role=\"alert\">
                <i class=\"bi bi-exclamation-circle\"></i> ";
                // line 728
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["message"], "html", null, true);
                yield "
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
            </div>
        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['message'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 732
            yield "        ";
            yield from $this->unwrap()->yieldBlock('content_login', $context, $blocks);
            // line 733
            yield "    ";
        }
        // line 734
        yield "    

    
 

    <script src=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js\"></script>
    <script>
        // Initialize AOS
        if (typeof AOS !== 'undefined') {
            AOS.init({
                duration: 400,
                easing: 'ease-out',
                once: true
            });
        }

        // Auto-dismiss alerts
        setTimeout(function() {
            document.querySelectorAll('.alert').forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
    ";
        // line 758
        yield from $this->unwrap()->yieldBlock('javascripts', $context, $blocks);
        // line 759
        yield "</body>
</html>
";
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Red Store - Gestion de Stock";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 598
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_stylesheets(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "stylesheets"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "stylesheets"));

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 668
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Dashboard";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 716
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 732
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content_login(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content_login"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content_login"));

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 758
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_javascripts(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "javascripts"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "javascripts"));

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "base.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  1068 => 758,  1046 => 732,  1024 => 716,  1001 => 668,  979 => 598,  956 => 6,  943 => 759,  941 => 758,  915 => 734,  912 => 733,  909 => 732,  899 => 728,  896 => 727,  891 => 726,  881 => 722,  878 => 721,  873 => 720,  868 => 717,  865 => 716,  855 => 712,  852 => 711,  847 => 710,  837 => 706,  834 => 705,  830 => 704,  819 => 696,  814 => 694,  806 => 689,  802 => 688,  795 => 685,  775 => 668,  766 => 661,  755 => 655,  752 => 654,  750 => 653,  740 => 648,  729 => 642,  718 => 636,  707 => 630,  696 => 624,  685 => 618,  676 => 612,  664 => 602,  662 => 601,  658 => 599,  656 => 598,  61 => 6,  54 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("<!DOCTYPE html>
<html lang=\"fr\" class=\"h-100\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>{% block title %}Red Store - Gestion de Stock{% endblock %}</title>
    
    <!-- Bootstrap 5 -->
    <link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css\" rel=\"stylesheet\">
    <!-- Bootstrap Icons -->
    <link rel=\"stylesheet\" href=\"https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css\">
    <!-- Google Fonts -->
    <link rel=\"preconnect\" href=\"https://fonts.googleapis.com\">
    <link rel=\"preconnect\" href=\"https://fonts.gstatic.com\" crossorigin>
    <link href=\"https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap\" rel=\"stylesheet\">
    <!-- Chart.js -->
    <script src=\"https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js\"></script>
    <!-- JsBarcode for barcode generation -->
    <script src=\"https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js\"></script>
    <!-- AOS Animation -->
    <link href=\"https://unpkg.com/aos@2.3.1/dist/aos.css\" rel=\"stylesheet\">
    <script src=\"https://unpkg.com/aos@2.3.1/dist/aos.js\"></script>
    
    <style>
        :root {
            --primary: #dc2626;
            --primary-hover: #b91c1c;
            --primary-light: #ef4444;
            --secondary: #1f2937;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #dc2626;
            --bg-primary: #ffffff;
            --bg-secondary: #f9fafb;
            --bg-tertiary: #f3f4f6;
            --border: #e5e7eb;
            --text-primary: #000000;
            --text-secondary: #1f2937;
            --text-tertiary: #6b7280;
            --sidebar-width: 260px;
            --header-height: 64px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: var(--bg-secondary);
            color: var(--text-primary);
            line-height: 1.6;
            font-size: 14px;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        /* Sidebar - Style moderne */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: var(--bg-primary);
            border-right: 1px solid var(--border);
            z-index: 1000;
            overflow-y: auto;
            transition: all 0.3s ease;
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 3px;
        }

        .sidebar-header {
            padding: 1.5rem 1.25rem;
            border-bottom: 1px solid var(--border);
            height: var(--header-height);
            display: flex;
            align-items: center;
        }

        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-size: 1.125rem;
            font-weight: 700;
            color: var(--text-primary);
            text-decoration: none;
        }

        .sidebar-logo i {
            font-size: 1.5rem;
            color: var(--primary);
        }
        
        .sidebar-logo span {
            background: linear-gradient(135deg, var(--primary) 0%, #000000 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-weight: 800;
            letter-spacing: -0.5px;
        }

        .sidebar-nav {
            padding: 0.75rem;
        }

        .nav-item {
            margin-bottom: 0.25rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.625rem 0.875rem;
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: 0.5rem;
            transition: all 0.2s ease;
            font-weight: 500;
            font-size: 0.875rem;
        }

        .nav-link:hover {
            background: var(--bg-tertiary);
            color: var(--text-primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .nav-link i {
            font-size: 1.125rem;
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            transition: margin-left 0.3s ease;
            display: flex;
            flex-direction: column;
        }

        /* Header */
        .topbar {
            background: var(--bg-primary);
            height: var(--header-height);
            padding: 0 2rem;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .page-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0;
        }

        .topbar-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .topbar-icon {
            width: 36px;
            height: 36px;
            border-radius: 0.5rem;
            background: var(--bg-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--text-secondary);
            cursor: pointer;
            transition: all 0.2s ease;
            position: relative;
        }

        .topbar-icon:hover {
            background: var(--bg-tertiary);
            color: var(--text-primary);
        }

        .topbar-icon .badge {
            position: absolute;
            top: -4px;
            right: -4px;
            background: var(--danger);
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid var(--bg-primary);
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.375rem 0.5rem;
            border-radius: 0.5rem;
            cursor: pointer;
            transition: background 0.2s ease;
        }

        .user-profile:hover {
            background: var(--bg-secondary);
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 0.5rem;
            background: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 0.75rem;
        }

        .user-info {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 500;
            font-size: 0.875rem;
            color: var(--text-primary);
            line-height: 1.2;
        }

        .user-role {
            font-size: 0.75rem;
            color: var(--text-tertiary);
            line-height: 1.2;
        }

        /* Content Area */
        .content-area {
            padding: 2rem;
            flex: 1;
            overflow-y: auto;
        }

        /* Cards */
        .card {
            background: var(--bg-primary);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            transition: all 0.2s ease;
        }

        .card:hover {
            border-color: var(--primary);
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.08);
        }

        /* Product Card */
        .product-card {
            background: var(--bg-primary);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.25rem;
            transition: all 0.2s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .product-card:hover {
            border-color: var(--primary);
            box-shadow: 0 8px 24px rgba(220, 38, 38, 0.12);
            transform: translateY(-2px);
        }

        .product-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }

        .product-title {
            font-size: 1rem;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0 0 0.5rem 0;
        }

        .product-badges {
            display: flex;
            gap: 0.5rem;
            flex-wrap: wrap;
            margin-bottom: 1rem;
        }

        .badge {
            padding: 0.25rem 0.625rem;
            border-radius: 0.375rem;
            font-size: 0.75rem;
            font-weight: 500;
        }

        .badge-category {
            background: var(--bg-tertiary);
            color: var(--text-secondary);
        }

        .badge-state {
            background: var(--success);
            color: white;
        }

        .badge-state.warning {
            background: var(--warning);
        }

        .product-info {
            flex-grow: 1;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px solid var(--border);
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-size: 0.875rem;
            color: var(--text-tertiary);
        }

        .info-value {
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .info-value.text-success {
            color: var(--success);
        }

        .info-value.text-danger {
            color: var(--danger);
        }

        .product-actions {
            display: flex;
            gap: 0.5rem;
            margin-top: 1rem;
            padding-top: 1rem;
            border-top: 1px solid var(--border);
        }

        /* Buttons */
        .btn {
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
            font-weight: 500;
            font-size: 0.875rem;
            transition: all 0.2s ease;
            border: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-hover);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
        }

        .btn-outline-primary {
            background: transparent;
            color: var(--primary);
            border: 1px solid var(--primary);
        }

        .btn-outline-primary:hover {
            background: var(--primary);
            color: white;
        }

        .btn-sm {
            padding: 0.375rem 0.75rem;
            font-size: 0.8125rem;
        }
        
        .btn-primary-modern {
            background: var(--primary);
            color: white;
            font-weight: 600;
            border: none;
        }
        
        .btn-primary-modern:hover {
            background: var(--primary-hover);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
        }
        
        .btn-modern {
            border-radius: 0.5rem;
            transition: all 0.2s ease;
        }
        
        .card-modern {
            background: var(--bg-primary);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        
        .card-header-modern {
            padding: 1.25rem 1.5rem;
            border-bottom: 1px solid var(--border);
            background: var(--bg-secondary);
            border-radius: 0.75rem 0.75rem 0 0;
        }
        
        .card-body-modern {
            padding: 1.5rem;
        }

        /* Forms */
        .form-label {
            font-weight: 500;
            font-size: 0.875rem;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
        }

        .form-control,
        .form-select {
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            padding: 0.625rem 0.875rem;
            font-size: 0.875rem;
            transition: all 0.2s ease;
            background: var(--bg-primary);
        }

        .form-control:focus,
        .form-select:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        .input-group-text {
            background: var(--bg-secondary);
            border: 1px solid var(--border);
            border-right: none;
            color: var(--text-secondary);
        }

        /* Tables */
        .table {
            background: var(--bg-primary);
            border-radius: 0.75rem;
            overflow: hidden;
            border: 1px solid var(--border);
        }

        .table thead {
            background: var(--bg-secondary);
        }

        .table th {
            font-weight: 600;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: var(--text-secondary);
            padding: 0.875rem 1rem;
            border: none;
        }

        .table td {
            padding: 1rem;
            border-top: 1px solid var(--border);
            vertical-align: middle;
        }

        .table tbody tr {
            transition: background 0.2s ease;
        }

        .table tbody tr:hover {
            background: var(--bg-secondary);
        }

        /* Alerts */
        .alert {
            border-radius: 0.5rem;
            border: none;
            padding: 0.875rem 1rem;
            font-size: 0.875rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .main-content {
                margin-left: 0;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-in {
            animation: fadeIn 0.4s ease;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 4rem 2rem;
        }

        .empty-state i {
            font-size: 4rem;
            color: var(--text-tertiary);
            margin-bottom: 1rem;
        }

        .empty-state h5 {
            color: var(--text-secondary);
            margin-bottom: 0.5rem;
        }

        .empty-state p {
            color: var(--text-tertiary);
            margin-bottom: 1.5rem;
        }
    </style>
    
    {% block stylesheets %}{% endblock %}
</head>
<body>
    {% if app.user %}
    <!-- Sidebar -->
    <aside class=\"sidebar\">
        <div class=\"sidebar-header\">
            <a href=\"/\" class=\"sidebar-logo\">
                <i class=\"bi bi-box-seam\"></i>
                <span style=\"color: var(--primary); font-weight: 800;\">Red Store</span>
            </a>
        </div>
        <nav class=\"sidebar-nav\">
            <div class=\"nav-item\">
                <a href=\"/\" class=\"nav-link {{ app.request.get('_route') == 'dashboard_index' or app.request.pathInfo == '/' ? 'active' : '' }}\">
                    <i class=\"bi bi-speedometer2\"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"{{ path('produits_index') }}\" class=\"nav-link {{ 'produits' in app.request.get('_route') ? 'active' : '' }}\">
                    <i class=\"bi bi-box\"></i>
                    <span>Produits</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"{{ path('ventes_index') }}\" class=\"nav-link {{ 'ventes' in app.request.get('_route') ? 'active' : '' }}\">
                    <i class=\"bi bi-cart-check\"></i>
                    <span>Ventes</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"{{ path('fournisseurs_index') }}\" class=\"nav-link {{ 'fournisseurs' in app.request.get('_route') ? 'active' : '' }}\">
                    <i class=\"bi bi-truck\"></i>
                    <span>Fournisseurs</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"{{ path('depenses_index') }}\" class=\"nav-link {{ 'depenses' in app.request.get('_route') ? 'active' : '' }}\">
                    <i class=\"bi bi-cash-stack\"></i>
                    <span>Dépenses</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"{{ path('bilan_index') }}\" class=\"nav-link {{ 'bilan' in app.request.get('_route') ? 'active' : '' }}\">
                    <i class=\"bi bi-graph-up\"></i>
                    <span>Bilan</span>
                </a>
            </div>
            <div class=\"nav-item\">
                <a href=\"{{ path('credits_index') }}\" class=\"nav-link {{ 'credits' in app.request.get('_route') ? 'active' : '' }}\">
                    <i class=\"bi bi-credit-card\"></i>
                    <span>Crédits</span>
                </a>
            </div>
            {% if is_granted('ROLE_MANAGER') %}
            <div class=\"nav-item\">
                <a href=\"{{ path('categories_index') }}\" class=\"nav-link {{ 'categories' in app.request.get('_route') ? 'active' : '' }}\">
                    <i class=\"bi bi-tags\"></i>
                    <span>Catégories</span>
                </a>
            </div>
            {% endif %}
        </nav>
    </aside>

    <!-- Main Content -->
    <div class=\"main-content\">
        <!-- Top Bar -->
        <div class=\"topbar\">
            <h1 class=\"page-title\">{% block page_title %}Dashboard{% endblock %}</h1>
            <div class=\"topbar-right\">
                <div class=\"topbar-icon\" data-bs-toggle=\"dropdown\">
                    <i class=\"bi bi-bell\"></i>
                    <span class=\"badge\">3</span>
                </div>
                <ul class=\"dropdown-menu dropdown-menu-end shadow-lg\" style=\"min-width: 300px; border-radius: 0.75rem; border: 1px solid var(--border);\">
                    <li><h6 class=\"dropdown-header\">Notifications</h6></li>
                    <li><hr class=\"dropdown-divider\"></li>
                    <li><a class=\"dropdown-item\" href=\"#\"><small class=\"text-muted\">12:47 pm</small><br>Stock faible détecté</a></li>
                    <li><a class=\"dropdown-item\" href=\"#\"><small class=\"text-muted\">11:30 pm</small><br>Nouvelle vente enregistrée</a></li>
                    <li><a class=\"dropdown-item\" href=\"#\"><small class=\"text-muted\">11:21 pm</small><br>Commande reçue</a></li>
                </ul>
                
                <div class=\"dropdown\">
                    <div class=\"user-profile\" data-bs-toggle=\"dropdown\">
                        <div class=\"user-avatar\">
                            {{ app.user.prenom|slice(0, 1) }}{{ app.user.nom|slice(0, 1) }}
                        </div>
                        <div class=\"user-info\">
                            <div class=\"user-name\">{{ app.user.getFullName() }}</div>
                            <div class=\"user-role\">{{ app.user.roles[0]|replace({'ROLE_': ''}) }}</div>
                        </div>
                        <i class=\"bi bi-chevron-down\" style=\"font-size: 0.75rem; color: var(--text-tertiary);\"></i>
                    </div>
                    <ul class=\"dropdown-menu dropdown-menu-end shadow-lg\" style=\"border-radius: 0.75rem; border: 1px solid var(--border);\">
                        <li><h6 class=\"dropdown-header fw-bold\">{{ app.user.getFullName() }}</h6></li>
                        <li><hr class=\"dropdown-divider\"></li>
                        <li><a class=\"dropdown-item\" href=\"{{ path('logout') }}\"><i class=\"bi bi-box-arrow-right\"></i> Déconnexion</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class=\"content-area fade-in\">
            {% for message in app.flashes('success') %}
                <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                    <i class=\"bi bi-check-circle\"></i> {{ message }}
                    <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
                </div>
            {% endfor %}
            {% for message in app.flashes('error') %}
                <div class=\"alert alert-danger alert-dismissible fade show\" role=\"alert\">
                    <i class=\"bi bi-exclamation-circle\"></i> {{ message }}
                    <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
                </div>
            {% endfor %}
            {% block content %}{% endblock %}
        </div>
    </div>
    {% else %}
        {% for message in app.flashes('success') %}
            <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                <i class=\"bi bi-check-circle\"></i> {{ message }}
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
            </div>
        {% endfor %}
        {% for message in app.flashes('error') %}
            <div class=\"alert alert-danger alert-dismissible fade show\" role=\"alert\">
                <i class=\"bi bi-exclamation-circle\"></i> {{ message }}
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
            </div>
        {% endfor %}
        {% block content_login %}{% endblock %}
    {% endif %}
    

    
 

    <script src=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js\"></script>
    <script>
        // Initialize AOS
        if (typeof AOS !== 'undefined') {
            AOS.init({
                duration: 400,
                easing: 'ease-out',
                once: true
            });
        }

        // Auto-dismiss alerts
        setTimeout(function() {
            document.querySelectorAll('.alert').forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
    {% block javascripts %}{% endblock %}
</body>
</html>
", "base.html.twig", "/var/www/html/templates/base.html.twig");
    }
}
