<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* fournisseur/index.html.twig */
class __TwigTemplate_6124060e874ab09cce20db7ab6d9efc0 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "fournisseur/index.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "fournisseur/index.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Fournisseurs - Stock Manager";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Fournisseurs";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<style>
    .fournisseurs-container {
        padding: 2rem 0;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid var(--border);
    }
    
    .page-header h1 {
        font-size: 1.875rem;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
    }
    
    .page-header .subtitle {
        color: var(--text-secondary);
        font-size: 0.9375rem;
        margin-top: 0.5rem;
    }
    
    .btn-modern {
        padding: 0.625rem 1.25rem;
        font-weight: 500;
        border-radius: 0.5rem;
        transition: all 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        border: none;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .btn-modern:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }
    
    .btn-primary-modern {
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
    }
    
    .btn-primary-modern:hover {
        background: linear-gradient(135deg, var(--primary-hover) 0%, var(--primary) 100%);
        color: white;
    }
    
    .fournisseur-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        height: 100%;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border: 1px solid var(--border);
        position: relative;
        overflow: hidden;
    }
    
    .fournisseur-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, var(--primary) 0%, var(--primary-light) 100%);
        transform: scaleX(0);
        transition: transform 0.3s ease;
    }
    
    .fournisseur-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        border-color: var(--primary);
    }
    
    .fournisseur-card:hover::before {
        transform: scaleX(1);
    }
    
    .fournisseur-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 1rem;
    }
    
    .fournisseur-name {
        font-size: 1.25rem;
        font-weight: 600;
        color: var(--text-primary);
        margin: 0;
    }
    
    .statut-badge {
        padding: 0.25rem 0.75rem;
        border-radius: 1rem;
        font-size: 0.75rem;
        font-weight: 500;
    }
    
    .statut-actif {
        background: rgba(34, 197, 94, 0.1);
        color: #16a34a;
    }
    
    .statut-desactive {
        background: rgba(239, 68, 68, 0.1);
        color: #dc2626;
    }
    
    .fournisseur-info {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
        margin-bottom: 1.5rem;
        font-size: 0.875rem;
        color: var(--text-secondary);
    }
    
    .info-item {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .info-item i {
        color: var(--primary);
        width: 16px;
    }
    
    .fournisseur-stats {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 1rem;
        margin-bottom: 1.5rem;
        padding-top: 1rem;
        border-top: 1px solid var(--border);
    }
    
    .stat-box {
        text-align: center;
    }
    
    .stat-label {
        font-size: 0.75rem;
        color: var(--text-secondary);
        margin-bottom: 0.25rem;
    }
    
    .stat-value {
        font-size: 1.125rem;
        font-weight: 600;
        color: var(--text-primary);
    }
    
    .stat-value.positive {
        color: #16a34a;
    }
    
    .stat-value.negative {
        color: #dc2626;
    }
    
    .fournisseur-actions {
        display: flex;
        gap: 0.5rem;
    }
    
    .btn-action {
        flex: 1;
        padding: 0.625rem;
        border-radius: 0.5rem;
        font-weight: 500;
        font-size: 0.875rem;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.375rem;
        text-decoration: none;
    }
    
    .btn-view {
        background: var(--primary);
        color: white;
    }
    
    .btn-view:hover {
        background: var(--primary-hover);
        color: white;
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(37, 99, 235, 0.3);
    }
    
    .btn-edit {
        background: var(--bg-secondary);
        color: var(--text-primary);
        border: 1px solid var(--border);
    }
    
    .btn-edit:hover {
        background: var(--bg-tertiary);
        border-color: var(--primary);
        color: var(--primary);
    }
    
    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        background: white;
        border-radius: 1rem;
        border: 2px dashed var(--border);
    }
    
    .empty-state i {
        font-size: 4rem;
        color: var(--text-tertiary);
        margin-bottom: 1rem;
    }
    
    .empty-state h3 {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 0.5rem;
    }
    
    .empty-state p {
        color: var(--text-secondary);
        margin-bottom: 2rem;
    }
</style>

<div class=\"fournisseurs-container\">
    <div class=\"page-header\">
        <div>
            <h1>Fournisseurs</h1>
            <p class=\"subtitle\">Gérez vos fournisseurs et suivez vos paiements</p>
        </div>
        <div style=\"display: flex; gap: 0.75rem;\">
            <a href=\"";
        // line 255
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_alertes");
        yield "\" class=\"btn btn-modern\" style=\"background: var(--bg-secondary); color: var(--text-primary); border: 1px solid var(--border);\">
                <i class=\"bi bi-bell\"></i>
                <span>Alertes</span>
            </a>
            ";
        // line 259
        if ((($tmp = $this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_MANAGER")) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 260
            yield "            <a href=\"";
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_new");
            yield "\" class=\"btn btn-primary-modern btn-modern\">
                <i class=\"bi bi-plus-circle-fill\"></i>
                <span>Nouveau fournisseur</span>
            </a>
            ";
        }
        // line 265
        yield "        </div>
    </div>

    ";
        // line 268
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["fournisseurs"]) || array_key_exists("fournisseurs", $context) ? $context["fournisseurs"] : (function () { throw new RuntimeError('Variable "fournisseurs" does not exist.', 268, $this->source); })())) > 0)) {
            // line 269
            yield "    <div class=\"row g-4\">
        ";
            // line 270
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["fournisseurs"]) || array_key_exists("fournisseurs", $context) ? $context["fournisseurs"] : (function () { throw new RuntimeError('Variable "fournisseurs" does not exist.', 270, $this->source); })()));
            $context['loop'] = [
              'parent' => $context['_parent'],
              'index0' => 0,
              'index'  => 1,
              'first'  => true,
            ];
            if (is_array($context['_seq']) || (is_object($context['_seq']) && $context['_seq'] instanceof \Countable)) {
                $length = count($context['_seq']);
                $context['loop']['revindex0'] = $length - 1;
                $context['loop']['revindex'] = $length;
                $context['loop']['length'] = $length;
                $context['loop']['last'] = 1 === $length;
            }
            foreach ($context['_seq'] as $context["_key"] => $context["fournisseur"]) {
                // line 271
                yield "        ";
                $context["data"] = (((CoreExtension::getAttribute($this->env, $this->source, ($context["fournisseursData"] ?? null), CoreExtension::getAttribute($this->env, $this->source, $context["loop"], "index0", [], "any", false, false, false, 271), [], "array", true, true, false, 271) &&  !(null === CoreExtension::getAttribute($this->env, $this->source, (isset($context["fournisseursData"]) || array_key_exists("fournisseursData", $context) ? $context["fournisseursData"] : (function () { throw new RuntimeError('Variable "fournisseursData" does not exist.', 271, $this->source); })()), CoreExtension::getAttribute($this->env, $this->source, $context["loop"], "index0", [], "any", false, false, false, 271), [], "array", false, false, false, 271)))) ? (CoreExtension::getAttribute($this->env, $this->source, (isset($context["fournisseursData"]) || array_key_exists("fournisseursData", $context) ? $context["fournisseursData"] : (function () { throw new RuntimeError('Variable "fournisseursData" does not exist.', 271, $this->source); })()), CoreExtension::getAttribute($this->env, $this->source, $context["loop"], "index0", [], "any", false, false, false, 271), [], "array", false, false, false, 271)) : (null));
                // line 272
                yield "        <div class=\"col-lg-4 col-md-6\" data-aos=\"fade-up\" data-aos-delay=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((CoreExtension::getAttribute($this->env, $this->source, $context["loop"], "index0", [], "any", false, false, false, 272) * 50), "html", null, true);
                yield "\">
            <div class=\"fournisseur-card\">
                <div class=\"fournisseur-header\">
                    <h3 class=\"fournisseur-name\">";
                // line 275
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "nom", [], "any", false, false, false, 275), "html", null, true);
                yield "</h3>
                    <span class=\"statut-badge ";
                // line 276
                yield (((($tmp = CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "isActif", [], "method", false, false, false, 276)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) ? ("statut-actif") : ("statut-desactive"));
                yield "\">
                        ";
                // line 277
                yield (((($tmp = CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "isActif", [], "method", false, false, false, 277)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) ? ("Actif") : ("Désactivé"));
                yield "
                    </span>
                </div>
                
                <div class=\"fournisseur-info\">
                    <div class=\"info-item\">
                        <i class=\"bi bi-tag\"></i>
                        <span>";
                // line 284
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::capitalize($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "type", [], "any", false, false, false, 284)), "html", null, true);
                yield "</span>
                    </div>
                    ";
                // line 286
                if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "telephones", [], "any", false, false, false, 286)) > 0)) {
                    // line 287
                    yield "                    <div class=\"info-item\">
                        <i class=\"bi bi-telephone\"></i>
                        <span>";
                    // line 289
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "telephones", [], "any", false, false, false, 289), 0, [], "array", false, false, false, 289), "html", null, true);
                    yield "</span>
                    </div>
                    ";
                }
                // line 292
                yield "                    ";
                if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "email", [], "any", false, false, false, 292)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                    // line 293
                    yield "                    <div class=\"info-item\">
                        <i class=\"bi bi-envelope\"></i>
                        <span>";
                    // line 295
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "email", [], "any", false, false, false, 295), "html", null, true);
                    yield "</span>
                    </div>
                    ";
                }
                // line 298
                yield "                </div>
                
                ";
                // line 300
                if ((($tmp = (isset($context["data"]) || array_key_exists("data", $context) ? $context["data"] : (function () { throw new RuntimeError('Variable "data" does not exist.', 300, $this->source); })())) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                    // line 301
                    yield "                <div class=\"fournisseur-stats\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Total dû</div>
                        <div class=\"stat-value ";
                    // line 304
                    yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["data"]) || array_key_exists("data", $context) ? $context["data"] : (function () { throw new RuntimeError('Variable "data" does not exist.', 304, $this->source); })()), "resteDu", [], "any", false, false, false, 304) > 0)) ? ("negative") : ("positive"));
                    yield "\">
                            ";
                    // line 305
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["data"]) || array_key_exists("data", $context) ? $context["data"] : (function () { throw new RuntimeError('Variable "data" does not exist.', 305, $this->source); })()), "resteDu", [], "any", false, false, false, 305), 2, ",", " "), "html", null, true);
                    yield " MAD
                        </div>
                    </div>
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Total payé</div>
                        <div class=\"stat-value positive\">
                            ";
                    // line 311
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["data"]) || array_key_exists("data", $context) ? $context["data"] : (function () { throw new RuntimeError('Variable "data" does not exist.', 311, $this->source); })()), "totalPaye", [], "any", false, false, false, 311), 2, ",", " "), "html", null, true);
                    yield " MAD
                        </div>
                    </div>
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Total achats</div>
                        <div class=\"stat-value\">
                            ";
                    // line 317
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["data"]) || array_key_exists("data", $context) ? $context["data"] : (function () { throw new RuntimeError('Variable "data" does not exist.', 317, $this->source); })()), "totalAchats", [], "any", false, false, false, 317), 2, ",", " "), "html", null, true);
                    yield " MAD
                        </div>
                    </div>
                </div>
                ";
                }
                // line 322
                yield "                
                <div class=\"fournisseur-actions\">
                    <a href=\"";
                // line 324
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_show", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "id", [], "any", false, false, false, 324)]), "html", null, true);
                yield "\" class=\"btn-action btn-view\">
                        <i class=\"bi bi-eye\"></i>
                        <span>Détails</span>
                    </a>
                    ";
                // line 328
                if ((($tmp = $this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_MANAGER")) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                    // line 329
                    yield "                    <a href=\"";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_edit", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["fournisseur"], "id", [], "any", false, false, false, 329)]), "html", null, true);
                    yield "\" class=\"btn-action btn-edit\">
                        <i class=\"bi bi-pencil\"></i>
                    </a>
                    ";
                }
                // line 333
                yield "                </div>
            </div>
        </div>
        ";
                ++$context['loop']['index0'];
                ++$context['loop']['index'];
                $context['loop']['first'] = false;
                if (isset($context['loop']['revindex0'], $context['loop']['revindex'])) {
                    --$context['loop']['revindex0'];
                    --$context['loop']['revindex'];
                    $context['loop']['last'] = 0 === $context['loop']['revindex0'];
                }
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['fournisseur'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 337
            yield "    </div>
    ";
        } else {
            // line 339
            yield "    <div class=\"empty-state\" data-aos=\"fade-up\">
        <i class=\"bi bi-inbox\"></i>
        <h3>Aucun fournisseur</h3>
        <p>Créez votre premier fournisseur pour commencer à gérer vos achats</p>
        ";
            // line 343
            if ((($tmp = $this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_MANAGER")) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 344
                yield "        <a href=\"";
                yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("fournisseurs_new");
                yield "\" class=\"btn btn-primary-modern btn-modern\">
            <i class=\"bi bi-plus-circle-fill\"></i>
            <span>Créer un fournisseur</span>
        </a>
        ";
            }
            // line 349
            yield "    </div>
    ";
        }
        // line 351
        yield "</div>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "fournisseur/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  581 => 351,  577 => 349,  568 => 344,  566 => 343,  560 => 339,  556 => 337,  539 => 333,  531 => 329,  529 => 328,  522 => 324,  518 => 322,  510 => 317,  501 => 311,  492 => 305,  488 => 304,  483 => 301,  481 => 300,  477 => 298,  471 => 295,  467 => 293,  464 => 292,  458 => 289,  454 => 287,  452 => 286,  447 => 284,  437 => 277,  433 => 276,  429 => 275,  422 => 272,  419 => 271,  402 => 270,  399 => 269,  397 => 268,  392 => 265,  383 => 260,  381 => 259,  374 => 255,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Fournisseurs - Stock Manager{% endblock %}
{% block page_title %}Fournisseurs{% endblock %}

{% block content %}
<style>
    .fournisseurs-container {
        padding: 2rem 0;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid var(--border);
    }
    
    .page-header h1 {
        font-size: 1.875rem;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
    }
    
    .page-header .subtitle {
        color: var(--text-secondary);
        font-size: 0.9375rem;
        margin-top: 0.5rem;
    }
    
    .btn-modern {
        padding: 0.625rem 1.25rem;
        font-weight: 500;
        border-radius: 0.5rem;
        transition: all 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        border: none;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .btn-modern:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }
    
    .btn-primary-modern {
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
    }
    
    .btn-primary-modern:hover {
        background: linear-gradient(135deg, var(--primary-hover) 0%, var(--primary) 100%);
        color: white;
    }
    
    .fournisseur-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        height: 100%;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border: 1px solid var(--border);
        position: relative;
        overflow: hidden;
    }
    
    .fournisseur-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, var(--primary) 0%, var(--primary-light) 100%);
        transform: scaleX(0);
        transition: transform 0.3s ease;
    }
    
    .fournisseur-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        border-color: var(--primary);
    }
    
    .fournisseur-card:hover::before {
        transform: scaleX(1);
    }
    
    .fournisseur-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 1rem;
    }
    
    .fournisseur-name {
        font-size: 1.25rem;
        font-weight: 600;
        color: var(--text-primary);
        margin: 0;
    }
    
    .statut-badge {
        padding: 0.25rem 0.75rem;
        border-radius: 1rem;
        font-size: 0.75rem;
        font-weight: 500;
    }
    
    .statut-actif {
        background: rgba(34, 197, 94, 0.1);
        color: #16a34a;
    }
    
    .statut-desactive {
        background: rgba(239, 68, 68, 0.1);
        color: #dc2626;
    }
    
    .fournisseur-info {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
        margin-bottom: 1.5rem;
        font-size: 0.875rem;
        color: var(--text-secondary);
    }
    
    .info-item {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .info-item i {
        color: var(--primary);
        width: 16px;
    }
    
    .fournisseur-stats {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 1rem;
        margin-bottom: 1.5rem;
        padding-top: 1rem;
        border-top: 1px solid var(--border);
    }
    
    .stat-box {
        text-align: center;
    }
    
    .stat-label {
        font-size: 0.75rem;
        color: var(--text-secondary);
        margin-bottom: 0.25rem;
    }
    
    .stat-value {
        font-size: 1.125rem;
        font-weight: 600;
        color: var(--text-primary);
    }
    
    .stat-value.positive {
        color: #16a34a;
    }
    
    .stat-value.negative {
        color: #dc2626;
    }
    
    .fournisseur-actions {
        display: flex;
        gap: 0.5rem;
    }
    
    .btn-action {
        flex: 1;
        padding: 0.625rem;
        border-radius: 0.5rem;
        font-weight: 500;
        font-size: 0.875rem;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.375rem;
        text-decoration: none;
    }
    
    .btn-view {
        background: var(--primary);
        color: white;
    }
    
    .btn-view:hover {
        background: var(--primary-hover);
        color: white;
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(37, 99, 235, 0.3);
    }
    
    .btn-edit {
        background: var(--bg-secondary);
        color: var(--text-primary);
        border: 1px solid var(--border);
    }
    
    .btn-edit:hover {
        background: var(--bg-tertiary);
        border-color: var(--primary);
        color: var(--primary);
    }
    
    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        background: white;
        border-radius: 1rem;
        border: 2px dashed var(--border);
    }
    
    .empty-state i {
        font-size: 4rem;
        color: var(--text-tertiary);
        margin-bottom: 1rem;
    }
    
    .empty-state h3 {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 0.5rem;
    }
    
    .empty-state p {
        color: var(--text-secondary);
        margin-bottom: 2rem;
    }
</style>

<div class=\"fournisseurs-container\">
    <div class=\"page-header\">
        <div>
            <h1>Fournisseurs</h1>
            <p class=\"subtitle\">Gérez vos fournisseurs et suivez vos paiements</p>
        </div>
        <div style=\"display: flex; gap: 0.75rem;\">
            <a href=\"{{ path('fournisseurs_alertes') }}\" class=\"btn btn-modern\" style=\"background: var(--bg-secondary); color: var(--text-primary); border: 1px solid var(--border);\">
                <i class=\"bi bi-bell\"></i>
                <span>Alertes</span>
            </a>
            {% if is_granted('ROLE_MANAGER') %}
            <a href=\"{{ path('fournisseurs_new') }}\" class=\"btn btn-primary-modern btn-modern\">
                <i class=\"bi bi-plus-circle-fill\"></i>
                <span>Nouveau fournisseur</span>
            </a>
            {% endif %}
        </div>
    </div>

    {% if fournisseurs|length > 0 %}
    <div class=\"row g-4\">
        {% for fournisseur in fournisseurs %}
        {% set data = fournisseursData[loop.index0] ?? null %}
        <div class=\"col-lg-4 col-md-6\" data-aos=\"fade-up\" data-aos-delay=\"{{ loop.index0 * 50 }}\">
            <div class=\"fournisseur-card\">
                <div class=\"fournisseur-header\">
                    <h3 class=\"fournisseur-name\">{{ fournisseur.nom }}</h3>
                    <span class=\"statut-badge {{ fournisseur.isActif() ? 'statut-actif' : 'statut-desactive' }}\">
                        {{ fournisseur.isActif() ? 'Actif' : 'Désactivé' }}
                    </span>
                </div>
                
                <div class=\"fournisseur-info\">
                    <div class=\"info-item\">
                        <i class=\"bi bi-tag\"></i>
                        <span>{{ fournisseur.type|capitalize }}</span>
                    </div>
                    {% if fournisseur.telephones|length > 0 %}
                    <div class=\"info-item\">
                        <i class=\"bi bi-telephone\"></i>
                        <span>{{ fournisseur.telephones[0] }}</span>
                    </div>
                    {% endif %}
                    {% if fournisseur.email %}
                    <div class=\"info-item\">
                        <i class=\"bi bi-envelope\"></i>
                        <span>{{ fournisseur.email }}</span>
                    </div>
                    {% endif %}
                </div>
                
                {% if data %}
                <div class=\"fournisseur-stats\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Total dû</div>
                        <div class=\"stat-value {{ data.resteDu > 0 ? 'negative' : 'positive' }}\">
                            {{ data.resteDu|number_format(2, ',', ' ') }} MAD
                        </div>
                    </div>
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Total payé</div>
                        <div class=\"stat-value positive\">
                            {{ data.totalPaye|number_format(2, ',', ' ') }} MAD
                        </div>
                    </div>
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Total achats</div>
                        <div class=\"stat-value\">
                            {{ data.totalAchats|number_format(2, ',', ' ') }} MAD
                        </div>
                    </div>
                </div>
                {% endif %}
                
                <div class=\"fournisseur-actions\">
                    <a href=\"{{ path('fournisseurs_show', {'id': fournisseur.id}) }}\" class=\"btn-action btn-view\">
                        <i class=\"bi bi-eye\"></i>
                        <span>Détails</span>
                    </a>
                    {% if is_granted('ROLE_MANAGER') %}
                    <a href=\"{{ path('fournisseurs_edit', {'id': fournisseur.id}) }}\" class=\"btn-action btn-edit\">
                        <i class=\"bi bi-pencil\"></i>
                    </a>
                    {% endif %}
                </div>
            </div>
        </div>
        {% endfor %}
    </div>
    {% else %}
    <div class=\"empty-state\" data-aos=\"fade-up\">
        <i class=\"bi bi-inbox\"></i>
        <h3>Aucun fournisseur</h3>
        <p>Créez votre premier fournisseur pour commencer à gérer vos achats</p>
        {% if is_granted('ROLE_MANAGER') %}
        <a href=\"{{ path('fournisseurs_new') }}\" class=\"btn btn-primary-modern btn-modern\">
            <i class=\"bi bi-plus-circle-fill\"></i>
            <span>Créer un fournisseur</span>
        </a>
        {% endif %}
    </div>
    {% endif %}
</div>
{% endblock %}
", "fournisseur/index.html.twig", "/var/www/html/templates/fournisseur/index.html.twig");
    }
}
