#!/bin/bash

# Script de sauvegarde de la base de données
# Usage: ./backup.sh

set -e

# Configuration
BACKUP_DIR="/var/backups/facture"
DATE=$(date +%Y%m%d_%H%M%S)
PROJECT_DIR="/var/www/facture"
DB_CONTAINER="saasinfo_mysql_prod"

# Créer le répertoire de sauvegarde s'il n'existe pas
mkdir -p "$BACKUP_DIR"

echo "📦 Début de la sauvegarde..."

# Récupérer les variables d'environnement de la base de données
cd "$PROJECT_DIR" || exit 1

# Sauvegarder la base de données
echo "💾 Sauvegarde de la base de données..."
docker-compose -f docker-compose.prod.yml exec -T db mysqldump \
    -u"${MYSQL_USER:-saasinfo}" \
    -p"${MYSQL_PASSWORD:-saasinfo}" \
    "${MYSQL_DATABASE:-saasinfo}" \
    > "$BACKUP_DIR/backup_$DATE.sql"

# Compresser la sauvegarde
echo "🗜️  Compression de la sauvegarde..."
gzip "$BACKUP_DIR/backup_$DATE.sql"

# Sauvegarder les uploads
echo "📁 Sauvegarde des fichiers uploadés..."
tar -czf "$BACKUP_DIR/uploads_$DATE.tar.gz" -C "$PROJECT_DIR/public" uploads

echo "✅ Sauvegarde terminée: backup_$DATE.sql.gz et uploads_$DATE.tar.gz"

# Supprimer les sauvegardes de plus de 30 jours
echo "🧹 Nettoyage des anciennes sauvegardes..."
find "$BACKUP_DIR" -name "backup_*.sql.gz" -mtime +30 -delete
find "$BACKUP_DIR" -name "uploads_*.tar.gz" -mtime +30 -delete

echo "✨ Terminé!"

