<?php

namespace App\Form;

use App\Entity\Vente;
use App\Entity\LigneVente;
use App\Entity\Produit;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class VenteType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $magasin = $options['magasin'];

        $builder
            ->add('numeroFacture', TextType::class, ['disabled' => true])
            ->add('lignesVente', CollectionType::class, [
                'entry_type' => LigneVenteType::class,
                'entry_options' => ['magasin' => $magasin],
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
            ])
            ->add('reduction', MoneyType::class, [
                'currency' => 'EUR',
                'required' => false,
                'data' => '0.00',
            ])
            ->add('modePaiement', ChoiceType::class, [
                'choices' => [
                    'Cash' => Vente::MODE_PAIEMENT_CASH,
                    'Carte' => Vente::MODE_PAIEMENT_CARTE,
                    'Transfert' => Vente::MODE_PAIEMENT_TRANSFERT,
                    'Crédit' => Vente::MODE_PAIEMENT_CREDIT,
                ],
            ])
            ->add('notes', TextareaType::class, ['required' => false]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Vente::class,
            'magasin' => null,
        ]);
    }
}

