<?php

namespace App\Repository;

use App\Entity\Vente;
use App\Entity\Magasin;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class VenteRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Vente::class);
    }

    public function findVentesByMagasinAndDate(Magasin $magasin, \DateTime $dateDebut, \DateTime $dateFin): array
    {
        return $this->createQueryBuilder('v')
            ->where('v.magasin = :magasin')
            ->andWhere('v.dateVente BETWEEN :dateDebut AND :dateFin')
            ->setParameter('magasin', $magasin)
            ->setParameter('dateDebut', $dateDebut)
            ->setParameter('dateFin', $dateFin)
            ->orderBy('v.dateVente', 'DESC')
            ->getQuery()
            ->getResult();
    }
}

