<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* vente/index.html.twig */
class __TwigTemplate_e011248a8907922c9b245c795ce0eaba extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/index.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/index.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Ventes - Stock Manager";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Ventes";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "    <div class=\"d-flex justify-content-between align-items-center mb-4\">
        <div>
            <p class=\"text-muted mb-0\" style=\"font-size: 0.875rem;\">Historique de vos ventes</p>
        </div>
        <a href=\"";
        // line 11
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_nouvelle");
        yield "\" class=\"btn btn-primary\">
            <i class=\"bi bi-plus\"></i> Nouvelle vente
        </a>
    </div>

    <!-- Filters -->
    <div class=\"card mb-4\">
        <div class=\"card-header\">
            <h5 class=\"mb-0\">Filtres</h5>
        </div>
        <div class=\"card-body\">
            <form method=\"get\" class=\"row g-3\">
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Date début</label>
                    <input type=\"date\" name=\"date_debut\" class=\"form-control\" value=\"";
        // line 25
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 25, $this->source); })()), "date_debut", [], "any", false, false, false, 25), "html", null, true);
        yield "\">
                </div>
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Date fin</label>
                    <input type=\"date\" name=\"date_fin\" class=\"form-control\" value=\"";
        // line 29
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 29, $this->source); })()), "date_fin", [], "any", false, false, false, 29), "html", null, true);
        yield "\">
                </div>
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Client</label>
                    <select name=\"client\" class=\"form-select\">
                        <option value=\"\">Tous les clients</option>
                        ";
        // line 35
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable((isset($context["clients"]) || array_key_exists("clients", $context) ? $context["clients"] : (function () { throw new RuntimeError('Variable "clients" does not exist.', 35, $this->source); })()));
        foreach ($context['_seq'] as $context["_key"] => $context["client"]) {
            // line 36
            yield "                        <option value=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["client"], "id", [], "any", false, false, false, 36), "html", null, true);
            yield "\" ";
            yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 36, $this->source); })()), "client", [], "any", false, false, false, 36) == CoreExtension::getAttribute($this->env, $this->source, $context["client"], "id", [], "any", false, false, false, 36))) ? ("selected") : (""));
            yield ">
                            ";
            // line 37
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["client"], "nom", [], "any", false, false, false, 37), "html", null, true);
            yield "
                        </option>
                        ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['client'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 40
        yield "                    </select>
                </div>
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Statut paiement</label>
                    <select name=\"statut_paiement\" class=\"form-select\">
                        <option value=\"\">Tous</option>
                        <option value=\"paye\" ";
        // line 46
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 46, $this->source); })()), "statut_paiement", [], "any", false, false, false, 46) == "paye")) ? ("selected") : (""));
        yield ">Payé</option>
                        <option value=\"partiel\" ";
        // line 47
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 47, $this->source); })()), "statut_paiement", [], "any", false, false, false, 47) == "partiel")) ? ("selected") : (""));
        yield ">Partiel</option>
                        <option value=\"impaye\" ";
        // line 48
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 48, $this->source); })()), "statut_paiement", [], "any", false, false, false, 48) == "impaye")) ? ("selected") : (""));
        yield ">Impayé</option>
                    </select>
                </div>
                <div class=\"col-12 d-flex gap-2\">
                    <button type=\"submit\" class=\"btn btn-primary\">
                        <i class=\"bi bi-funnel\"></i> Filtrer
                    </button>
                    <a href=\"";
        // line 55
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_index");
        yield "\" class=\"btn btn-outline-secondary\">
                        <i class=\"bi bi-arrow-counterclockwise\"></i> Réinitialiser
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Sales Table -->
    <div class=\"card\">
        <div class=\"table-responsive\">
            <table class=\"table mb-0\">
                <thead>
                    <tr>
                        <th>N° Facture</th>
                        <th>Date</th>
                        <th>Client</th>
                        <th>Vendeur</th>
                        <th>Montant total</th>
                        <th>Payé / Restant</th>
                        <th>Statut</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    ";
        // line 80
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable((isset($context["ventes"]) || array_key_exists("ventes", $context) ? $context["ventes"] : (function () { throw new RuntimeError('Variable "ventes" does not exist.', 80, $this->source); })()));
        $context['_iterated'] = false;
        foreach ($context['_seq'] as $context["_key"] => $context["vente"]) {
            // line 81
            yield "                    <tr>
                        <td><strong>";
            // line 82
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "numeroFacture", [], "any", false, false, false, 82), "html", null, true);
            yield "</strong></td>
                        <td>";
            // line 83
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "dateVente", [], "any", false, false, false, 83), "d/m/Y H:i"), "html", null, true);
            yield "</td>
                        <td>
                            ";
            // line 85
            if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "client", [], "any", false, false, false, 85)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 86
                yield "                                <strong>";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "client", [], "any", false, false, false, 86), "nom", [], "any", false, false, false, 86), "html", null, true);
                yield "</strong><br>
                                <small class=\"text-muted\">";
                // line 87
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "client", [], "any", false, false, false, 87), "telephone", [], "any", false, false, false, 87), "html", null, true);
                yield "</small>
                            ";
            } else {
                // line 89
                yield "                                <span class=\"text-muted\">Client rapide</span>
                            ";
            }
            // line 91
            yield "                        </td>
                        <td>";
            // line 92
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "vendeur", [], "any", false, false, false, 92), "getFullName", [], "method", false, false, false, 92), "html", null, true);
            yield "</td>
                        <td><strong style=\"color: var(--primary);\">";
            // line 93
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantFinal", [], "any", false, false, false, 93), 2, ",", " "), "html", null, true);
            yield " MAD</strong></td>
                        <td>
                            <span style=\"color: var(--success);\">";
            // line 95
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantPaye", [], "any", false, false, false, 95), 2, ",", " "), "html", null, true);
            yield " MAD</span>
                            ";
            // line 96
            if ((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantRestant", [], "any", false, false, false, 96) > 0)) {
                // line 97
                yield "                            <br><span style=\"color: var(--danger);\">- ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantRestant", [], "any", false, false, false, 97), 2, ",", " "), "html", null, true);
                yield " MAD</span>
                            ";
            }
            // line 99
            yield "                        </td>
                        <td>
                            ";
            // line 101
            if ((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "statutPaiement", [], "any", false, false, false, 101) == "paye")) {
                // line 102
                yield "                                <span class=\"badge badge-success\">Payé</span>
                            ";
            } elseif ((CoreExtension::getAttribute($this->env, $this->source,             // line 103
$context["vente"], "statutPaiement", [], "any", false, false, false, 103) == "partiel")) {
                // line 104
                yield "                                <span class=\"badge badge-warning\">Partiel</span>
                            ";
            } else {
                // line 106
                yield "                                <span class=\"badge badge-danger\">Impayé</span>
                            ";
            }
            // line 108
            yield "                        </td>
                        <td>
                            <div class=\"btn-group\">
                                <a href=\"";
            // line 111
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_show", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "id", [], "any", false, false, false, 111)]), "html", null, true);
            yield "\" class=\"btn btn-sm btn-outline-primary\">
                                    <i class=\"bi bi-eye\"></i>
                                </a>
                                <a href=\"";
            // line 114
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_imprimer", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "id", [], "any", false, false, false, 114)]), "html", null, true);
            yield "\" class=\"btn btn-sm btn-outline-secondary\" target=\"_blank\">
                                    <i class=\"bi bi-printer\"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    ";
            $context['_iterated'] = true;
        }
        // line 120
        if (!$context['_iterated']) {
            // line 121
            yield "                    <tr>
                        <td colspan=\"8\" class=\"text-center py-5\">
                            <div class=\"empty-state\">
                                <i class=\"bi bi-inbox\" style=\"font-size: 3rem; color: var(--text-tertiary);\"></i>
                                <h5>Aucune vente enregistrée</h5>
                                <p>Commencez par créer votre première vente</p>
                                <a href=\"";
            // line 127
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_nouvelle");
            yield "\" class=\"btn btn-primary\">
                                    <i class=\"bi bi-plus\"></i> Nouvelle vente
                                </a>
                            </div>
                        </td>
                    </tr>
                    ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['vente'], $context['_parent'], $context['_iterated']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 134
        yield "                </tbody>
            </table>
        </div>
    </div>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "vente/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  358 => 134,  345 => 127,  337 => 121,  335 => 120,  324 => 114,  318 => 111,  313 => 108,  309 => 106,  305 => 104,  303 => 103,  300 => 102,  298 => 101,  294 => 99,  288 => 97,  286 => 96,  282 => 95,  277 => 93,  273 => 92,  270 => 91,  266 => 89,  261 => 87,  256 => 86,  254 => 85,  249 => 83,  245 => 82,  242 => 81,  237 => 80,  209 => 55,  199 => 48,  195 => 47,  191 => 46,  183 => 40,  174 => 37,  167 => 36,  163 => 35,  154 => 29,  147 => 25,  130 => 11,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Ventes - Stock Manager{% endblock %}
{% block page_title %}Ventes{% endblock %}

{% block content %}
    <div class=\"d-flex justify-content-between align-items-center mb-4\">
        <div>
            <p class=\"text-muted mb-0\" style=\"font-size: 0.875rem;\">Historique de vos ventes</p>
        </div>
        <a href=\"{{ path('ventes_nouvelle') }}\" class=\"btn btn-primary\">
            <i class=\"bi bi-plus\"></i> Nouvelle vente
        </a>
    </div>

    <!-- Filters -->
    <div class=\"card mb-4\">
        <div class=\"card-header\">
            <h5 class=\"mb-0\">Filtres</h5>
        </div>
        <div class=\"card-body\">
            <form method=\"get\" class=\"row g-3\">
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Date début</label>
                    <input type=\"date\" name=\"date_debut\" class=\"form-control\" value=\"{{ filters.date_debut }}\">
                </div>
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Date fin</label>
                    <input type=\"date\" name=\"date_fin\" class=\"form-control\" value=\"{{ filters.date_fin }}\">
                </div>
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Client</label>
                    <select name=\"client\" class=\"form-select\">
                        <option value=\"\">Tous les clients</option>
                        {% for client in clients %}
                        <option value=\"{{ client.id }}\" {{ filters.client == client.id ? 'selected' : '' }}>
                            {{ client.nom }}
                        </option>
                        {% endfor %}
                    </select>
                </div>
                <div class=\"col-md-3\">
                    <label class=\"form-label\">Statut paiement</label>
                    <select name=\"statut_paiement\" class=\"form-select\">
                        <option value=\"\">Tous</option>
                        <option value=\"paye\" {{ filters.statut_paiement == 'paye' ? 'selected' : '' }}>Payé</option>
                        <option value=\"partiel\" {{ filters.statut_paiement == 'partiel' ? 'selected' : '' }}>Partiel</option>
                        <option value=\"impaye\" {{ filters.statut_paiement == 'impaye' ? 'selected' : '' }}>Impayé</option>
                    </select>
                </div>
                <div class=\"col-12 d-flex gap-2\">
                    <button type=\"submit\" class=\"btn btn-primary\">
                        <i class=\"bi bi-funnel\"></i> Filtrer
                    </button>
                    <a href=\"{{ path('ventes_index') }}\" class=\"btn btn-outline-secondary\">
                        <i class=\"bi bi-arrow-counterclockwise\"></i> Réinitialiser
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Sales Table -->
    <div class=\"card\">
        <div class=\"table-responsive\">
            <table class=\"table mb-0\">
                <thead>
                    <tr>
                        <th>N° Facture</th>
                        <th>Date</th>
                        <th>Client</th>
                        <th>Vendeur</th>
                        <th>Montant total</th>
                        <th>Payé / Restant</th>
                        <th>Statut</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    {% for vente in ventes %}
                    <tr>
                        <td><strong>{{ vente.numeroFacture }}</strong></td>
                        <td>{{ vente.dateVente|date('d/m/Y H:i') }}</td>
                        <td>
                            {% if vente.client %}
                                <strong>{{ vente.client.nom }}</strong><br>
                                <small class=\"text-muted\">{{ vente.client.telephone }}</small>
                            {% else %}
                                <span class=\"text-muted\">Client rapide</span>
                            {% endif %}
                        </td>
                        <td>{{ vente.vendeur.getFullName() }}</td>
                        <td><strong style=\"color: var(--primary);\">{{ vente.montantFinal|number_format(2, ',', ' ') }} MAD</strong></td>
                        <td>
                            <span style=\"color: var(--success);\">{{ vente.montantPaye|number_format(2, ',', ' ') }} MAD</span>
                            {% if vente.montantRestant > 0 %}
                            <br><span style=\"color: var(--danger);\">- {{ vente.montantRestant|number_format(2, ',', ' ') }} MAD</span>
                            {% endif %}
                        </td>
                        <td>
                            {% if vente.statutPaiement == 'paye' %}
                                <span class=\"badge badge-success\">Payé</span>
                            {% elseif vente.statutPaiement == 'partiel' %}
                                <span class=\"badge badge-warning\">Partiel</span>
                            {% else %}
                                <span class=\"badge badge-danger\">Impayé</span>
                            {% endif %}
                        </td>
                        <td>
                            <div class=\"btn-group\">
                                <a href=\"{{ path('ventes_show', {'id': vente.id}) }}\" class=\"btn btn-sm btn-outline-primary\">
                                    <i class=\"bi bi-eye\"></i>
                                </a>
                                <a href=\"{{ path('ventes_imprimer', {'id': vente.id}) }}\" class=\"btn btn-sm btn-outline-secondary\" target=\"_blank\">
                                    <i class=\"bi bi-printer\"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    {% else %}
                    <tr>
                        <td colspan=\"8\" class=\"text-center py-5\">
                            <div class=\"empty-state\">
                                <i class=\"bi bi-inbox\" style=\"font-size: 3rem; color: var(--text-tertiary);\"></i>
                                <h5>Aucune vente enregistrée</h5>
                                <p>Commencez par créer votre première vente</p>
                                <a href=\"{{ path('ventes_nouvelle') }}\" class=\"btn btn-primary\">
                                    <i class=\"bi bi-plus\"></i> Nouvelle vente
                                </a>
                            </div>
                        </td>
                    </tr>
                    {% endfor %}
                </tbody>
            </table>
        </div>
    </div>
{% endblock %}
", "vente/index.html.twig", "/var/www/html/templates/vente/index.html.twig");
    }
}
